/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.dal.remote.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactory;
import org.openbase.bco.dal.remote.unit.UnitRemoteFactoryImpl;
import org.openbase.bco.manager.agent.core.AbstractAgent;
import org.openbase.bco.manager.agent.core.AgentManagerController;
import org.openbase.bco.registry.device.lib.DeviceRegistry;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;

public class PowerStateSynchroniserAgent
extends AbstractAgent {
    public static final String SOURCE_KEY = "SOURCE";
    public static final String TARGET_KEY = "TARGET";
    public static final String SOURCE_BEHAVIOUR_KEY = "SOURCE_BEHAVIOUR";
    public static final String TARGET_BEHAVIOUR_KEY = "TARGET_BEHAVIOUR";
    private static final PowerStateType.PowerState ON = PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.ON).build();
    private static final PowerStateType.PowerState OFF = PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build();
    private PowerStateType.PowerState.State sourceLatestPowerState;
    private PowerStateType.PowerState.State targetLatestPowerState;
    private final List<UnitRemote> targetRemotes = new ArrayList<UnitRemote>();
    private UnitRemote sourceRemote;
    private PowerStateSyncBehaviour sourceBehaviour;
    private PowerStateSyncBehaviour targetBehaviour;
    private final UnitRemoteFactory factory = UnitRemoteFactoryImpl.getInstance();
    private final DeviceRegistry deviceRegistry = AgentManagerController.getInstance().getDeviceRegistry();
    private final Observer<GeneratedMessage> sourceObserver = new Observer<GeneratedMessage>(){

        public void update(Observable<GeneratedMessage> source, GeneratedMessage data) throws Exception {
            PowerStateSynchroniserAgent.this.sourceLatestPowerState = PowerStateSynchroniserAgent.this.invokeGetPowerState(data).getValue();
            System.out.println("Received new value [" + PowerStateSynchroniserAgent.this.sourceLatestPowerState + "] for source");
            PowerStateSynchroniserAgent.this.logger.info("Received new value [" + PowerStateSynchroniserAgent.this.sourceLatestPowerState + "] for source");
            if (PowerStateSynchroniserAgent.this.sourceLatestPowerState == PowerStateType.PowerState.State.OFF) {
                if (PowerStateSynchroniserAgent.this.targetLatestPowerState != PowerStateType.PowerState.State.OFF) {
                    for (UnitRemote targetRemote : PowerStateSynchroniserAgent.this.targetRemotes) {
                        PowerStateSynchroniserAgent.this.invokeSetPower(targetRemote, OFF);
                    }
                }
            } else if (PowerStateSynchroniserAgent.this.sourceLatestPowerState == PowerStateType.PowerState.State.ON) {
                switch (PowerStateSynchroniserAgent.this.targetBehaviour) {
                    case OFF: {
                        if (PowerStateSynchroniserAgent.this.targetLatestPowerState == PowerStateType.PowerState.State.OFF) break;
                        for (UnitRemote targetRemote : PowerStateSynchroniserAgent.this.targetRemotes) {
                            PowerStateSynchroniserAgent.this.invokeSetPower(targetRemote, OFF);
                        }
                        break;
                    }
                    case ON: {
                        if (PowerStateSynchroniserAgent.this.targetLatestPowerState == PowerStateType.PowerState.State.ON) break;
                        for (UnitRemote targetRemote : PowerStateSynchroniserAgent.this.targetRemotes) {
                            PowerStateSynchroniserAgent.this.invokeSetPower(targetRemote, ON);
                        }
                        break;
                    }
                }
            }
        }
    };
    private final Observer<GeneratedMessage> targetObserver = new Observer<GeneratedMessage>(){

        public void update(Observable<GeneratedMessage> source, GeneratedMessage data) throws Exception {
            PowerStateType.PowerState.State newPowerState = PowerStateSynchroniserAgent.this.invokeGetPowerState(data).getValue();
            System.out.println("Received new value [" + PowerStateSynchroniserAgent.this.targetLatestPowerState + "] for target [" + source + "]");
            PowerStateSynchroniserAgent.this.logger.info("Received new value [" + PowerStateSynchroniserAgent.this.targetLatestPowerState + "] for target [" + source + "]");
            if (!PowerStateSynchroniserAgent.this.updateLatestTargetPowerState(newPowerState)) {
                return;
            }
            if (PowerStateSynchroniserAgent.this.targetLatestPowerState == PowerStateType.PowerState.State.ON) {
                if (PowerStateSynchroniserAgent.this.sourceLatestPowerState != PowerStateType.PowerState.State.ON) {
                    PowerStateSynchroniserAgent.this.invokeSetPower(PowerStateSynchroniserAgent.this.sourceRemote, ON);
                }
            } else if (PowerStateSynchroniserAgent.this.targetLatestPowerState == PowerStateType.PowerState.State.OFF) {
                switch (PowerStateSynchroniserAgent.this.sourceBehaviour) {
                    case OFF: {
                        if (PowerStateSynchroniserAgent.this.sourceLatestPowerState == PowerStateType.PowerState.State.OFF) break;
                        PowerStateSynchroniserAgent.this.invokeSetPower(PowerStateSynchroniserAgent.this.sourceRemote, OFF);
                        break;
                    }
                    case ON: {
                        if (PowerStateSynchroniserAgent.this.sourceLatestPowerState == PowerStateType.PowerState.State.ON) break;
                        PowerStateSynchroniserAgent.this.invokeSetPower(PowerStateSynchroniserAgent.this.sourceRemote, ON);
                        break;
                    }
                }
            }
        }
    };

    public PowerStateSynchroniserAgent() throws InstantiationException, CouldNotPerformException {
        super(true);
    }

    @Override
    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.logger.debug("Creating PowerStateSynchroniserAgent[" + config.getLabel() + "]");
            MetaConfigVariableProvider configVariableProvider = new MetaConfigVariableProvider("PowerStateSynchroniserAgent", config.getMetaConfig());
            this.sourceRemote = this.factory.newInitializedInstance(this.deviceRegistry.getUnitConfigById(configVariableProvider.getValue(SOURCE_KEY)));
            int i = 1;
            try {
                String unitId;
                while (!(unitId = configVariableProvider.getValue("TARGET_" + i)).isEmpty()) {
                    this.logger.info("Found target id [" + unitId + "] with key [" + TARGET_KEY + "_" + i + "]");
                    this.targetRemotes.add(this.factory.newInitializedInstance(this.deviceRegistry.getUnitConfigById(unitId)));
                    ++i;
                }
            }
            catch (NotAvailableException ex) {
                this.logger.info("Found [" + --i + "] target/s");
            }
            this.sourceBehaviour = PowerStateSyncBehaviour.valueOf(configVariableProvider.getValue(SOURCE_BEHAVIOUR_KEY));
            this.targetBehaviour = PowerStateSyncBehaviour.valueOf(configVariableProvider.getValue(TARGET_BEHAVIOUR_KEY));
            this.logger.info("Initializing observers");
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    private boolean updateLatestTargetPowerState(PowerStateType.PowerState.State powerState) throws CouldNotPerformException {
        if (this.targetLatestPowerState == PowerStateType.PowerState.State.UNKNOWN) {
            this.targetLatestPowerState = powerState;
            return true;
        }
        if (this.targetLatestPowerState == PowerStateType.PowerState.State.OFF && powerState == PowerStateType.PowerState.State.ON) {
            this.targetLatestPowerState = PowerStateType.PowerState.State.ON;
            return true;
        }
        if (this.targetLatestPowerState == PowerStateType.PowerState.State.ON && powerState == PowerStateType.PowerState.State.OFF) {
            this.targetLatestPowerState = PowerStateType.PowerState.State.OFF;
            for (UnitRemote targetRemote : this.targetRemotes) {
                if (this.invokeGetPowerState(targetRemote.getData()).getValue() != PowerStateType.PowerState.State.ON) continue;
                this.targetLatestPowerState = PowerStateType.PowerState.State.ON;
                break;
            }
            return this.targetLatestPowerState == PowerStateType.PowerState.State.OFF;
        }
        return false;
    }

    private void invokeSetPower(UnitRemote remote, PowerStateType.PowerState powerState) {
        try {
            Method method = remote.getClass().getMethod("setPowerState", PowerStateType.PowerState.class);
            method.invoke((Object)remote, powerState);
        }
        catch (NoSuchMethodException ex) {
            ExceptionPrinter.printHistory((String)("Remote [" + remote.getClass().getSimpleName() + "] has no set Power method!"), (Throwable)ex, (Logger)this.logger);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            ExceptionPrinter.printHistory((String)("Could not invoke setPower method on remote [" + remote.getClass().getSimpleName() + "] with value [" + powerState + "]"), (Throwable)ex, (Logger)this.logger);
        }
    }

    private PowerStateType.PowerState invokeGetPowerState(Object message) throws CouldNotPerformException {
        try {
            Method method = message.getClass().getMethod("getPowerState", new Class[0]);
            return (PowerStateType.PowerState)method.invoke(message, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Could not get powerState from message [" + message + "]", (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Activating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        super.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Deactivating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        super.deactivate();
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Executing PowerStateSynchroniser agent");
        this.sourceRemote.activate();
        this.sourceRemote.waitForData();
        String targetIds = "";
        this.targetLatestPowerState = PowerStateType.PowerState.State.UNKNOWN;
        for (UnitRemote targetRemote : this.targetRemotes) {
            targetRemote.activate();
            targetRemote.waitForData();
            targetIds = targetIds + "[" + targetRemote.getId() + "]";
            if ((this.targetLatestPowerState == PowerStateType.PowerState.State.OFF || this.targetLatestPowerState == PowerStateType.PowerState.State.UNKNOWN) && this.invokeGetPowerState(targetRemote.getData()).getValue() == PowerStateType.PowerState.State.ON) {
                this.targetLatestPowerState = PowerStateType.PowerState.State.ON;
            } else if (this.targetLatestPowerState == PowerStateType.PowerState.State.UNKNOWN && this.invokeGetPowerState(targetRemote.getData()).getValue() == PowerStateType.PowerState.State.OFF) {
                this.targetLatestPowerState = PowerStateType.PowerState.State.OFF;
            }
            targetRemote.addDataObserver(this.targetObserver);
        }
        this.sourceRemote.addDataObserver(this.sourceObserver);
        this.sourceLatestPowerState = this.invokeGetPowerState(this.sourceRemote.getData()).getValue();
        this.logger.info("Source [" + this.sourceRemote.getId() + "], behaviour [" + (Object)((Object)this.sourceBehaviour) + "]");
        this.logger.info("Targets [" + targetIds + "], behaviour [" + (Object)((Object)this.targetBehaviour) + "]");
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Stopping PowerStateSynchroniserAgent...");
        this.sourceRemote.removeDataObserver(this.sourceObserver);
        for (UnitRemote targetRemote : this.targetRemotes) {
            targetRemote.removeDataObserver(this.sourceObserver);
            targetRemote.deactivate();
        }
        this.sourceRemote.deactivate();
    }

    public UnitRemote getSourceRemote() {
        return this.sourceRemote;
    }

    public List<UnitRemote> getTargetRemotes() {
        return this.targetRemotes;
    }

    public PowerStateSyncBehaviour getSourceBehaviour() {
        return this.sourceBehaviour;
    }

    public PowerStateSyncBehaviour getTargetBehaviour() {
        return this.targetBehaviour;
    }

    public static enum PowerStateSyncBehaviour {
        ON,
        OFF,
        LAST_STATE;

    }
}

