/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import java.util.concurrent.ExecutionException;
import org.openbase.bco.dal.lib.detector.PresenseDetector;
import org.openbase.bco.manager.agent.core.AbstractAgent;
import org.openbase.bco.manager.location.remote.LocationRemote;
import org.openbase.bco.registry.location.remote.CachedLocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.schedule.Timeout;
import org.slf4j.Logger;
import rst.domotic.action.SnapshotType;
import rst.domotic.unit.UnitConfigType;

public class StandbyAgent
extends AbstractAgent {
    public static final long TIEMOUT = 900000L;
    private LocationRemote locationRemote;
    private PresenseDetector presenseDetector;
    private final Timeout timeout;
    private final SyncObject standbySync = new SyncObject("StandbySync");
    private boolean standby = false;
    private SnapshotType.Snapshot snapshot;

    public StandbyAgent() throws InstantiationException, CouldNotPerformException, InterruptedException {
        super(false);
        this.timeout = new Timeout(900000L){

            public void expired() throws InterruptedException {
                try {
                    StandbyAgent.this.standby();
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)StandbyAgent.this.logger);
                }
            }
        };
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.locationRemote = new LocationRemote();
        CachedLocationRegistryRemote.waitForData();
        this.locationRemote.init((GeneratedMessage)CachedLocationRegistryRemote.getRegistry().getLocationConfigById(((UnitConfigType.UnitConfig)this.getConfig()).getId()));
        this.locationRemote.activate();
        this.presenseDetector = new PresenseDetector();
        super.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        this.locationRemote.deactivate();
        super.deactivate();
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.activate();
        this.timeout.start();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.timeout.cancel();
        this.locationRemote.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void standby() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            try {
                if (this.snapshot == null) {
                    return;
                }
                this.snapshot = (SnapshotType.Snapshot)this.locationRemote.recordSnapshot().get();
                this.standby = true;
            }
            catch (ExecutionException | CouldNotPerformException ex) {
                throw new CouldNotPerformException("Standby failed!", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            try {
                this.locationRemote.restoreSnapshot(this.snapshot).get();
                this.snapshot = null;
                this.standby = false;
            }
            catch (ExecutionException | CouldNotPerformException ex) {
                throw new CouldNotPerformException("WakeUp failed!", ex);
            }
        }
    }
}

