/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.openbase.bco.dal.remote.service.ColorStateServiceRemote;
import org.openbase.bco.manager.agent.core.AbstractAgent;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.bco.registry.unit.remote.UnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.InvalidStateException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.slf4j.Logger;
import rst.domotic.unit.UnitConfigType;
import rst.vision.HSBColorType;

public class AmbientColorAgent
extends AbstractAgent {
    private static final String COLOR_KEY = "COLOR";
    private static final String UNIT_KEY = "UNIT";
    private static final String HOLDING_TIME_KEY = "HOLDING_TIME";
    private static final String STRATEGY_KEY = "STRATEGY";
    private static final String SEPERATOR = ";";
    private ColoringStrategy strategy;
    private Thread thread;
    private long holdingTime;
    private final List<ColorStateServiceRemote> colorRemotes = new ArrayList<ColorStateServiceRemote>();
    private final List<HSBColorType.HSBColor> colors = new ArrayList<HSBColorType.HSBColor>();
    private final Random random;

    public AmbientColorAgent() throws InstantiationException, InterruptedException, CouldNotPerformException {
        this.logger.info("Creating AmbienColorAgent");
        this.random = new Random();
    }

    @Override
    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            super.init((GeneratedMessage)config);
            CachedUnitRegistryRemote.waitForData();
            UnitRegistryRemote unitRegistry = CachedUnitRegistryRemote.getRegistry();
            MetaConfigVariableProvider configVariableProvider = new MetaConfigVariableProvider("AmbientColorAgent", config.getMetaConfig());
            int i = 1;
            try {
                String unitId;
                while (!(unitId = configVariableProvider.getValue("UNIT_" + i)).isEmpty()) {
                    this.logger.info("Found unit id [" + unitId + "] with key [" + UNIT_KEY + "_" + i + "]");
                    ColorStateServiceRemote remote = new ColorStateServiceRemote();
                    remote.init(unitRegistry.getUnitConfigById(unitId));
                    this.colorRemotes.add(remote);
                    ++i;
                }
            }
            catch (NotAvailableException ex) {
                this.logger.info("Found [" + --i + "] unit/s");
            }
            i = 1;
            try {
                String colorString;
                while (!(colorString = configVariableProvider.getValue("COLOR_" + i)).isEmpty()) {
                    this.logger.info("Found color [" + colorString + "] with key [" + COLOR_KEY + "_" + i + "]");
                    String[] split = colorString.split(SEPERATOR);
                    double hue = Double.parseDouble(split[0]);
                    double saturation = Double.parseDouble(split[1]);
                    double brightness = Double.parseDouble(split[2]);
                    this.colors.add(HSBColorType.HSBColor.newBuilder().setHue(hue).setSaturation(saturation).setBrightness(brightness).build());
                    ++i;
                }
            }
            catch (NotAvailableException ex) {
                this.logger.info("Found [" + --i + "] color/s");
            }
            catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Error while parsing color. Use following patter [KEY,VALUE] => [COLOR,<hue>;<saturation>;<brightness>]", (Throwable)ex), (Logger)this.logger, (LogLevel)LogLevel.WARN);
            }
            this.holdingTime = Long.parseLong(configVariableProvider.getValue(HOLDING_TIME_KEY));
            this.strategy = ColoringStrategy.valueOf(configVariableProvider.getValue(STRATEGY_KEY));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        for (ColorStateServiceRemote colorRemote : this.colorRemotes) {
            colorRemote.activate();
        }
        super.activate();
    }

    public void execute() throws CouldNotPerformException {
        this.initColorStates();
        this.setExecutionThread();
        this.thread.start();
    }

    public void stop() throws CouldNotPerformException, InterruptedException {
        this.thread.interrupt();
        this.thread.join(10000L);
        if (this.thread.isAlive()) {
            throw new CouldNotPerformException("Fatal error: Could not stop " + (Object)((Object)this) + "!");
        }
    }

    private void initColorStates() throws CouldNotPerformException {
        for (ColorStateServiceRemote colorRemote : this.colorRemotes) {
            if (this.colors.contains(colorRemote.getColorState().getColor().getHsbColor())) continue;
            HSBColorType.HSBColor color = this.colors.get(this.random.nextInt(this.colors.size()));
            colorRemote.setColor(color);
        }
    }

    private void setExecutionThread() {
        switch (this.strategy) {
            case ALL: {
                this.thread = new AllStrategyThread();
                break;
            }
            case ONE: {
                this.thread = new OneStrategyThread();
                break;
            }
            default: {
                this.thread = new OneStrategyThread();
            }
        }
    }

    public String stringHSV(HSBColorType.HSBColor color) {
        return color.getHue() + SEPERATOR + color.getSaturation() + SEPERATOR + color.getBrightness();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        super.deactivate();
        for (ColorStateServiceRemote colorRemote : this.colorRemotes) {
            colorRemote.deactivate();
        }
    }

    private <T> T choseDifferentElem(List<T> list, T currentElem) {
        if (currentElem == null || list.size() == 1) {
            return list.get(0);
        }
        int oldIndex = list.indexOf(currentElem);
        if (oldIndex == -1) {
            return list.get(this.random.nextInt(list.size()));
        }
        int newIndex = this.random.nextInt(list.size());
        while (newIndex == oldIndex) {
            newIndex = this.random.nextInt(list.size());
        }
        return list.get(newIndex);
    }

    private class OneStrategyThread
    extends Thread {
        private OneStrategyThread() {
        }

        @Override
        public void run() {
            ColorStateServiceRemote remote = null;
            try {
                if (AmbientColorAgent.this.colorRemotes.isEmpty()) {
                    throw new InvalidStateException("No service remote available!");
                }
                while (AmbientColorAgent.this.isExecuting() && !Thread.interrupted()) {
                    try {
                        remote = (ColorStateServiceRemote)AmbientColorAgent.this.choseDifferentElem(AmbientColorAgent.this.colorRemotes, remote);
                        remote.setColor((HSBColorType.HSBColor)AmbientColorAgent.this.choseDifferentElem(AmbientColorAgent.this.colors, remote.getHSBColor()));
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not set/get color of [" + remote + "]", (Throwable)ex), (Logger)AmbientColorAgent.this.logger);
                    }
                    Thread.sleep(AmbientColorAgent.this.holdingTime);
                }
                AmbientColorAgent.this.logger.info("Execution thread finished.");
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Execution thread canceled!", (Throwable)ex), (Logger)AmbientColorAgent.this.logger);
            }
        }
    }

    private class AllStrategyThread
    extends Thread {
        private AllStrategyThread() {
        }

        @Override
        public void run() {
            try {
                if (AmbientColorAgent.this.colorRemotes.isEmpty()) {
                    throw new InvalidStateException("No service remote available!");
                }
                long delay = AmbientColorAgent.this.holdingTime / (long)AmbientColorAgent.this.colorRemotes.size();
                while (AmbientColorAgent.this.isExecuting() && !Thread.interrupted()) {
                    for (ColorStateServiceRemote colorRemote : AmbientColorAgent.this.colorRemotes) {
                        try {
                            colorRemote.setColor((HSBColorType.HSBColor)AmbientColorAgent.this.choseDifferentElem(AmbientColorAgent.this.colors, colorRemote.getHSBColor()));
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not set/get color of [" + colorRemote.getClass().getName() + "]", (Throwable)ex), (Logger)AmbientColorAgent.this.logger);
                        }
                        Thread.sleep(delay);
                    }
                }
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Execution thread canceled!", (Throwable)ex), (Logger)AmbientColorAgent.this.logger);
            }
        }
    }

    public static enum ColoringStrategy {
        ONE,
        ALL;

    }
}

