/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core;

import org.openbase.bco.manager.agent.core.AbstractAgent;
import org.openbase.bco.manager.agent.lib.Agent;
import org.openbase.bco.manager.agent.lib.AgentController;
import org.openbase.bco.manager.agent.lib.AgentFactory;
import org.openbase.bco.registry.agent.remote.CachedAgentRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.rsb.ScopeType;

public class AgentFactoryImpl
implements AgentFactory {
    protected final Logger logger = LoggerFactory.getLogger(AgentFactoryImpl.class);
    private static AgentFactoryImpl instance;

    public static synchronized AgentFactory getInstance() {
        if (instance == null) {
            instance = new AgentFactoryImpl();
        }
        return instance;
    }

    private AgentFactoryImpl() {
    }

    public AgentController newInstance(UnitConfigType.UnitConfig config) throws InstantiationException {
        AgentController agent;
        try {
            if (config == null) {
                throw new NotAvailableException("agentconfig");
            }
            if (!config.getAgentConfig().hasAgentClassId()) {
                throw new NotAvailableException("agentype");
            }
            if (!config.hasScope() && config.getScope().getComponentList().isEmpty()) {
                throw new NotAvailableException("scope");
            }
            CachedAgentRegistryRemote.waitForData();
            String agentClassLabel = CachedAgentRegistryRemote.getRegistry().getAgentClassById(config.getAgentConfig().getAgentClassId()).getLabel();
            Class<?> agentClass = Thread.currentThread().getContextClassLoader().loadClass(this.getAgentClass(agentClassLabel));
            this.logger.info("Creating agent of type [" + agentClass.getSimpleName() + "] on scope [" + ScopeGenerator.generateStringRep((ScopeType.Scope)config.getScope()) + "]");
            agent = (AgentController)agentClass.newInstance();
            agent.init(config);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | java.lang.InstantiationException | InterruptedException | SecurityException | CouldNotPerformException ex) {
            throw new InstantiationException(Agent.class, config.getId(), ex);
        }
        return agent;
    }

    private String getAgentClass(String agentClassLabel) {
        return AbstractAgent.class.getPackage().getName() + "." + "preset." + agentClassLabel + "Agent";
    }
}

