/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openbase.bco.dal.lib.layer.service.provider.BrightnessStateProviderService;
import org.openbase.bco.dal.remote.unit.BrightnessSensorRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.ObservableImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class BrightnessStateFutionProvider
extends ObservableImpl<Double>
implements BrightnessStateProviderService {
    public static final long DEFAULT_MEASUREMENT_TIME_WINDOW = 900L;
    public static final double UNKNOWN_VALUE = -1.0;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Double brightnessMinState;
    private Double brightnessMaxState;
    private Double brightnessAverageState;
    private final Map<Long, Double> brightnessLastStates;
    private final long measurementTimeWindow;
    private final List<BrightnessSensorRemote> brightnessSensorList;

    public BrightnessStateFutionProvider(Collection<UnitConfigType.UnitConfig> brightnessUnitConfigs) throws InstantiationException, InterruptedException {
        this(brightnessUnitConfigs, 900L);
    }

    public BrightnessStateFutionProvider(Collection<UnitConfigType.UnitConfig> brightnessUnitConfigs, long measurementTimeWindow) throws InstantiationException, InterruptedException {
        try {
            this.brightnessSensorList = new ArrayList<BrightnessSensorRemote>();
            this.brightnessLastStates = new HashMap<Long, Double>();
            this.measurementTimeWindow = measurementTimeWindow;
            this.brightnessMinState = -1.0;
            this.brightnessMaxState = -1.0;
            this.brightnessAverageState = -1.0;
            for (UnitConfigType.UnitConfig unitConfig : brightnessUnitConfigs) {
                if (unitConfig.getType() != UnitTemplateType.UnitTemplate.UnitType.MOTION_DETECTOR) {
                    this.logger.warn("Skip Unit[" + unitConfig.getId() + "] because its not of Type[" + UnitTemplateType.UnitTemplate.UnitType.MOTION_DETECTOR + "]!");
                    continue;
                }
                BrightnessSensorRemote brightnessSensorRemote = new BrightnessSensorRemote();
                brightnessSensorRemote.init((GeneratedMessage)unitConfig);
                this.brightnessSensorList.add(brightnessSensorRemote);
                brightnessSensorRemote.addDataObserver((source, data) -> this.updateBrightnessState(data.getBrightnessState().getBrightness()));
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    private synchronized void updateBrightnessState(Double brightnessState) {
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        if (this.brightnessAverageState == -1.0) {
            if (this.brightnessLastStates.isEmpty()) {
                throw new NotAvailableException("brightness");
            }
            return BrightnessStateType.BrightnessState.newBuilder().setBrightness(this.brightnessLastStates.values().stream().findFirst().get().doubleValue()).build();
        }
        return BrightnessStateType.BrightnessState.newBuilder().setBrightness(this.brightnessAverageState.doubleValue()).build();
    }

    public Double getBrightnessMinState() {
        return this.brightnessMinState;
    }

    public Double getBrightnessMaxState() {
        return this.brightnessMaxState;
    }

    public Double getBrightnessAverageState() {
        return this.brightnessAverageState;
    }

    public Map<Long, Double> getBrightnessLastStates() {
        return this.brightnessLastStates;
    }

    public long getMeasurementTimeWindow() {
        return this.measurementTimeWindow;
    }

    public List<BrightnessSensorRemote> getBrightnessSensorList() {
        return this.brightnessSensorList;
    }
}

