/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgent;
import org.openbase.bco.registry.location.remote.CachedLocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.schedule.Timeout;
import org.slf4j.Logger;
import rst.domotic.action.SnapshotType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.location.LocationDataType;

public class StandbyAgent
extends AbstractAgent {
    public static final long TIMEOUT = 900000L;
    private LocationRemote locationRemote;
    private final Timeout timeout;
    private final SyncObject standbySync = new SyncObject("StandbySync");
    private boolean standby = false;
    private SnapshotType.Snapshot snapshot;

    public StandbyAgent() throws InstantiationException, CouldNotPerformException, InterruptedException {
        this.timeout = new Timeout(900000L){

            public void expired() throws InterruptedException {
                try {
                    StandbyAgent.this.standby();
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)StandbyAgent.this.logger);
                }
            }
        };
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.locationRemote = new LocationRemote();
        CachedLocationRegistryRemote.waitForData();
        this.locationRemote.init((GeneratedMessage)CachedLocationRegistryRemote.getRegistry().getLocationConfigById(((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId()));
        this.locationRemote.addDataObserver((source, data) -> this.triggerPresenceChange((LocationDataType.LocationData)data));
        super.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerPresenceChange(LocationDataType.LocationData data) throws InterruptedException {
        System.out.println("trigger: " + data.getPresenceState().getValue().name());
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            if (data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.PRESENT)) {
                this.timeout.cancel();
                if (this.standby) {
                    try {
                        this.wakeUp();
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify motion state change!", (Throwable)ex), (Logger)this.logger);
                    }
                }
            } else if (data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.ABSENT) && !this.timeout.isActive()) {
                System.out.println("timeout start");
                this.timeout.start();
            }
        }
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        this.locationRemote.deactivate();
        super.deactivate();
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.activate();
        this.triggerPresenceChange((LocationDataType.LocationData)this.locationRemote.getData());
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.timeout.cancel();
        this.locationRemote.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void standby() throws CouldNotPerformException, InterruptedException {
        System.out.println("try to standby");
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            if (this.standby) {
                return;
            }
            this.logger.info("Standby " + this.locationRemote.getLabel() + "...");
            try {
                try {
                    this.logger.info("Create snapshot of " + this.locationRemote.getLabel() + " state.");
                    this.snapshot = (SnapshotType.Snapshot)this.locationRemote.recordSnapshot().get(10L, TimeUnit.SECONDS);
                }
                catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not create snapshot!", (Throwable)ex, (Logger)this.logger);
                }
                this.standby = true;
                this.logger.info("Switch off all devices...");
                this.locationRemote.setPowerState(PowerStateType.PowerState.State.OFF);
                this.logger.info(this.locationRemote.getLabel() + " is now standby.");
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Standby failed!", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Wake up " + this.locationRemote.getLabel() + "...");
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            this.standby = false;
            if (this.snapshot == null) {
                this.logger.info("skip wake up because no snapshot information available!");
                return;
            }
            try {
                this.logger.info("restore snapshot up");
                this.locationRemote.restoreSnapshot(this.snapshot).get();
                this.snapshot = null;
            }
            catch (ExecutionException | CouldNotPerformException ex) {
                throw new CouldNotPerformException("WakeUp failed!", ex);
            }
        }
    }
}

