/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;

public class PersonLightProviderAgent
extends AbstractAgentController {
    public static final double MINIMUM_LIGHT_THRESHOLD = 100.0;
    private LocationRemote locationRemote;

    public PersonLightProviderAgent() throws InstantiationException, CouldNotPerformException, InterruptedException {
        super(PersonLightProviderAgent.class);
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.locationRemote = new LocationRemote();
        Registries.getLocationRegistry().waitForData();
        this.locationRemote.init((GeneratedMessage)Registries.getLocationRegistry().getLocationConfigById(((UnitConfigType.UnitConfig)this.getConfig()).getId()));
        this.locationRemote.activate();
        this.locationRemote.addDataObserver((source, data) -> {
            try {
                this.notifyPresenceStateChanged((PresenceStateType.PresenceStateOrBuilder)data.getPresenceState());
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify presence state change!", (Throwable)ex), (Logger)this.logger);
            }
        });
        super.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        this.locationRemote.deactivate();
        super.deactivate();
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.activate();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.deactivate();
    }

    private void notifyPresenceStateChanged(PresenceStateType.PresenceStateOrBuilder presenceState) throws CouldNotPerformException {
        if (presenceState.getValue() == PresenceStateType.PresenceState.State.PRESENT) {
            this.locationRemote.setPowerState(PowerStateType.PowerState.State.ON);
        } else {
            this.locationRemote.setPowerState(PowerStateType.PowerState.State.OFF);
        }
        this.logger.info("detect: " + presenceState.getValue());
    }
}

