/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.schedule.Timeout;
import org.slf4j.Logger;
import rst.domotic.action.ActionConfigType;
import rst.domotic.action.SnapshotType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.location.LocationDataType;

public class StandbyAgent
extends AbstractAgentController {
    public static final long TIMEOUT = 900000L;
    private LocationRemote locationRemote;
    private final Timeout timeout;
    private final SyncObject standbySync = new SyncObject("StandbySync");
    private boolean standby = false;
    private final Observer<LocationDataType.LocationData> locationDataObserver;
    private SnapshotType.Snapshot snapshot;

    public StandbyAgent() throws InstantiationException, CouldNotPerformException, InterruptedException {
        super(StandbyAgent.class);
        this.timeout = new Timeout(900000L){

            public void expired() throws InterruptedException {
                try {
                    StandbyAgent.this.standby();
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)StandbyAgent.this.logger);
                }
            }
        };
        this.locationDataObserver = new Observer<LocationDataType.LocationData>(){

            public void update(Observable<LocationDataType.LocationData> source, LocationDataType.LocationData data) throws Exception {
                StandbyAgent.this.triggerPresenceChange(data);
            }
        };
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        this.locationRemote.addDataObserver(this.locationDataObserver);
        this.locationRemote.waitForData();
        this.triggerPresenceChange((LocationDataType.LocationData)this.locationRemote.getData());
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.locationRemote.removeDataObserver(this.locationDataObserver);
        this.timeout.cancel();
        this.locationRemote = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerPresenceChange(LocationDataType.LocationData data) throws InterruptedException {
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            if (data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.PRESENT)) {
                this.timeout.cancel();
                if (this.standby) {
                    try {
                        this.wakeUp();
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify motion state change!", (Throwable)ex), (Logger)this.logger);
                    }
                }
            } else if (data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.ABSENT) && !this.timeout.isActive()) {
                this.timeout.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void standby() throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            if (this.standby) {
                return;
            }
            this.logger.info("Standby " + this.locationRemote.getLabel() + "...");
            try {
                try {
                    this.logger.debug("Create snapshot of " + this.locationRemote.getLabel() + " state.");
                    this.snapshot = (SnapshotType.Snapshot)this.locationRemote.recordSnapshot().get(60L, TimeUnit.SECONDS);
                    ArrayList<ActionConfigType.ActionConfig> actionConfigList = new ArrayList<ActionConfigType.ActionConfig>();
                    for (ActionConfigType.ActionConfig actionConfig : this.snapshot.getActionConfigList()) {
                        if (actionConfig.getServiceAttribute().toLowerCase().contains("off")) {
                            this.logger.debug("ignore " + actionConfig.getUnitId() + " because unit is off.");
                            continue;
                        }
                        if (actionConfig.getServiceAttribute().toLowerCase().contains("brightness: 0.0")) {
                            this.logger.debug("ignore " + actionConfig.getUnitId() + " because brightness is 0.");
                            continue;
                        }
                        actionConfigList.add(actionConfig);
                    }
                    this.snapshot = this.snapshot.toBuilder().clearActionConfig().addAllActionConfig(actionConfigList).build();
                }
                catch (ExecutionException | TimeoutException | CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not create snapshot!", (Throwable)ex, (Logger)this.logger);
                }
                this.standby = true;
                this.logger.info("Switch off all devices in the " + this.locationRemote.getLabel());
                this.locationRemote.setPowerState(PowerStateType.PowerState.State.OFF);
                this.logger.info(this.locationRemote.getLabel() + " is now standby.");
            }
            catch (CouldNotPerformException ex) {
                throw new CouldNotPerformException("Standby failed!", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUp() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Wake up " + this.locationRemote.getLabel() + "...");
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            this.standby = false;
            if (this.snapshot == null) {
                this.logger.debug("skip wake up because no snapshot information available!");
                return;
            }
            try {
                this.logger.debug("restore snapshot: " + this.snapshot);
                this.locationRemote.restoreSnapshot(this.snapshot).get();
                this.snapshot = null;
            }
            catch (ExecutionException | CouldNotPerformException ex) {
                throw new CouldNotPerformException("WakeUp failed!", ex);
            }
        }
    }
}

