/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.TriggerDAL;

import com.google.protobuf.MessageOrBuilder;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.manager.agent.core.TriggerJUL.AbstractTrigger;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ActivationStateType;

public class AgentTriggerPool
implements Activatable,
Shutdownable {
    private boolean active = false;
    private final ObservableImpl<ActivationStateType.ActivationState> triggerObservable = new ObservableImpl((Object)this);
    private final List<AbstractTrigger> triggerListAND = new ArrayList<AbstractTrigger>();
    private final List<AbstractTrigger> triggerListOR = new ArrayList<AbstractTrigger>();
    private final Observer<ActivationStateType.ActivationState> triggerAndObserver = (source, data) -> this.verifyCondition();
    private final Observer<ActivationStateType.ActivationState> triggerOrObserver = (source, data) -> {
        if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
            if (!((ActivationStateType.ActivationState)this.triggerObservable.getValue()).getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.triggerObservable.notifyObservers((Object)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
            }
        } else {
            this.verifyCondition();
        }
    };

    public AgentTriggerPool() throws InstantiationException {
        try {
            this.triggerObservable.notifyObservers((Object)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)"Could not set initial state", (Throwable)ex);
        }
    }

    public void addTrigger(AbstractTrigger trigger, TriggerOperation triggerOperation) throws CouldNotPerformException {
        if (triggerOperation == TriggerOperation.AND) {
            this.triggerListAND.add(trigger);
        } else {
            this.triggerListOR.add(trigger);
        }
        if (this.active) {
            if (triggerOperation == TriggerOperation.AND) {
                trigger.registerObserver(this.triggerAndObserver);
            } else {
                trigger.registerObserver(this.triggerOrObserver);
            }
            try {
                trigger.activate();
            }
            catch (InterruptedException ex) {
                throw new CouldNotPerformException("Could not activate Trigger.", (Throwable)ex);
            }
            try {
                this.verifyCondition();
            }
            catch (NotAvailableException notAvailableException) {
                // empty catch block
            }
        }
    }

    public void removeTrigger(AbstractTrigger trigger) {
        if (this.triggerListAND.contains(trigger)) {
            trigger.deregisterObserver(this.triggerAndObserver);
            this.triggerListAND.remove(trigger);
        } else if (this.triggerListOR.contains(trigger)) {
            trigger.deregisterObserver(this.triggerOrObserver);
            this.triggerListOR.remove(trigger);
        }
    }

    public void registerObserver(Observer<ActivationStateType.ActivationState> observer) {
        this.triggerObservable.addObserver(observer);
    }

    public void deregisterObserver(Observer<ActivationStateType.ActivationState> observer) {
        this.triggerObservable.removeObserver(observer);
    }

    public ActivationStateType.ActivationState getActivationState() throws NotAvailableException {
        return (ActivationStateType.ActivationState)this.triggerObservable.getValue();
    }

    private void verifyCondition() throws CouldNotPerformException {
        if (this.verifyOrCondition() || this.verifyAndCondition()) {
            if (!((ActivationStateType.ActivationState)this.triggerObservable.getValue()).getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.triggerObservable.notifyObservers((Object)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
            }
        } else if (!((ActivationStateType.ActivationState)this.triggerObservable.getValue()).getValue().equals((Object)ActivationStateType.ActivationState.State.DEACTIVE)) {
            this.triggerObservable.notifyObservers((Object)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build()));
        }
    }

    private boolean verifyAndCondition() throws CouldNotPerformException {
        for (AbstractTrigger abstractTrigger : this.triggerListAND) {
            if (abstractTrigger.getActivationState().getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE) || abstractTrigger.getActivationState().getValue().equals((Object)ActivationStateType.ActivationState.State.UNKNOWN)) continue;
            return false;
        }
        return !this.triggerListAND.isEmpty();
    }

    private boolean verifyOrCondition() throws CouldNotPerformException {
        for (AbstractTrigger abstractTrigger : this.triggerListOR) {
            if (!abstractTrigger.getActivationState().getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) continue;
            return true;
        }
        return false;
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        for (AbstractTrigger abstractTrigger : this.triggerListAND) {
            abstractTrigger.registerObserver(this.triggerAndObserver);
            abstractTrigger.activate();
        }
        for (AbstractTrigger abstractTrigger : this.triggerListOR) {
            abstractTrigger.registerObserver(this.triggerOrObserver);
            abstractTrigger.activate();
        }
        this.verifyCondition();
        this.active = true;
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        for (AbstractTrigger abstractTrigger : this.triggerListAND) {
            abstractTrigger.deregisterObserver(this.triggerAndObserver);
            abstractTrigger.deactivate();
        }
        for (AbstractTrigger abstractTrigger : this.triggerListOR) {
            abstractTrigger.deregisterObserver(this.triggerOrObserver);
            abstractTrigger.deactivate();
        }
        this.triggerObservable.notifyObservers((Object)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        this.triggerObservable.shutdown();
    }

    public static enum TriggerOperation {
        AND,
        OR;

    }
}

