/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.TriggerJUL;

import com.google.protobuf.MessageOrBuilder;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Shutdownable;
import org.openbase.jul.pattern.ObservableImpl;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.ActivationStateType;

public abstract class AbstractTrigger
implements Shutdownable,
Activatable {
    private final ObservableImpl<ActivationStateType.ActivationState> triggerObservable = new ObservableImpl((Object)this);

    public AbstractTrigger() throws InstantiationException {
        try {
            this.triggerObservable.notifyObservers((Object)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)"Could not set initial state", (Throwable)ex);
        }
    }

    public ActivationStateType.ActivationState getActivationState() throws NotAvailableException {
        return (ActivationStateType.ActivationState)this.triggerObservable.getValue();
    }

    public void registerObserver(Observer<ActivationStateType.ActivationState> observer) {
        this.triggerObservable.addObserver(observer);
    }

    public void deregisterObserver(Observer<ActivationStateType.ActivationState> observer) {
        this.triggerObservable.removeObserver(observer);
    }

    protected void notifyChange(ActivationStateType.ActivationState newState) throws CouldNotPerformException {
        if (!((ActivationStateType.ActivationState)this.triggerObservable.getValue()).getValue().equals((Object)newState.getValue())) {
            this.triggerObservable.notifyObservers((Object)newState);
        }
    }

    public void shutdown() {
        this.triggerObservable.shutdown();
        try {
            this.deactivate();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
    }
}

