/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.TriggerJUL;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.MessageOrBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.manager.agent.core.TriggerJUL.AbstractTrigger;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.pattern.Remote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;

public class GenericTrigger<UR extends AbstractUnitRemote, DT extends GeneratedMessage, STE extends Enum<STE>>
extends AbstractTrigger {
    private final UR unitRemote;
    private final STE targetState;
    private final ServiceTemplateType.ServiceTemplate.ServiceType serviceType;
    private final Observer<DT> dataObserver;
    private final Observer<Remote.ConnectionState> connectionObserver;
    private boolean active = false;

    public GenericTrigger(UR unitRemote, STE targetState, ServiceTemplateType.ServiceTemplate.ServiceType serviceType) throws InstantiationException {
        this.unitRemote = unitRemote;
        this.targetState = targetState;
        this.serviceType = serviceType;
        this.dataObserver = (source, data) -> this.verifyCondition(data);
        this.connectionObserver = (source, data) -> this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
    }

    private void verifyCondition(DT data) {
        try {
            Object serviceState = Services.invokeProviderServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)this.serviceType, data, (Object[])new Object[0]);
            Method method = serviceState.getClass().getMethod("getValue", new Class[0]);
            if (method.invoke(serviceState, new Object[0]).equals(this.targetState)) {
                this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build()));
            } else {
                this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build()));
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not verify condition " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        catch (NoSuchMethodException ex) {
            ExceptionPrinter.printHistory((String)("Method not known " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        catch (SecurityException ex) {
            ExceptionPrinter.printHistory((String)("Security Exception " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        catch (IllegalAccessException ex) {
            ExceptionPrinter.printHistory((String)("Illegal Access Exception " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        catch (IllegalArgumentException ex) {
            ExceptionPrinter.printHistory((String)("Illegal Argument Exception " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        catch (InvocationTargetException ex) {
            ExceptionPrinter.printHistory((String)("Could not invoke method " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.unitRemote.addDataObserver(this.dataObserver);
        this.unitRemote.addConnectionStateObserver(this.connectionObserver);
        this.active = true;
        this.verifyCondition(this.unitRemote.getData());
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.unitRemote.removeDataObserver(this.dataObserver);
        this.unitRemote.removeConnectionStateObserver(this.connectionObserver);
        this.active = false;
        this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.UNKNOWN).build()));
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public void shutdown() {
        try {
            this.deactivate();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        super.shutdown();
    }
}

