/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.List;
import java.util.concurrent.Future;
import org.openbase.bco.dal.remote.unit.UnitGroupRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.manager.agent.core.TriggerDAL.AgentTriggerPool;
import org.openbase.bco.manager.agent.core.TriggerJUL.GenericTrigger;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.Observer;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class AbsenceEnergySavingAgent
extends AbstractAgentController {
    private LocationRemote locationRemote;
    private Future<ActionFutureType.ActionFuture> setLightPowerStateFuture;
    private Future<ActionFutureType.ActionFuture> setMultimediaPowerStateFuture;
    private final PresenceStateType.PresenceState.State triggerState = PresenceStateType.PresenceState.State.ABSENT;
    private final Observer<ActivationStateType.ActivationState> triggerHolderObserver = (source, data) -> {
        if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
            this.switchlightsOff();
            this.switchMultimediaOff();
        } else {
            if (this.setLightPowerStateFuture != null && !this.setLightPowerStateFuture.isDone()) {
                this.setLightPowerStateFuture.cancel(true);
            }
            if (this.setMultimediaPowerStateFuture != null && !this.setMultimediaPowerStateFuture.isDone()) {
                this.setMultimediaPowerStateFuture.cancel(true);
            }
        }
    };

    public AbsenceEnergySavingAgent() throws InstantiationException {
        super(AbsenceEnergySavingAgent.class);
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
        }
        try {
            GenericTrigger agentTrigger = new GenericTrigger(this.locationRemote, this.triggerState, ServiceTemplateType.ServiceTemplate.ServiceType.PRESENCE_STATE_SERVICE);
            this.agentTriggerHolder.addTrigger(agentTrigger, AgentTriggerPool.TriggerOperation.OR);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
        }
        this.agentTriggerHolder.registerObserver(this.triggerHolderObserver);
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.agentTriggerHolder.activate();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.agentTriggerHolder.deactivate();
    }

    public void shutdown() {
        this.agentTriggerHolder.deregisterObserver(this.triggerHolderObserver);
        this.agentTriggerHolder.shutdown();
        super.shutdown();
    }

    private void switchlightsOff() {
        this.logger.info("Switch lights off");
        try {
            this.setLightPowerStateFuture = this.locationRemote.setPowerState(PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT);
        }
        catch (CouldNotPerformException ex) {
            this.logger.error("Could not set Powerstate of Lights.");
        }
    }

    private void switchMultimediaOff() {
        try {
            List unitsByLabel = Units.getUnitsByLabel((String)this.locationRemote.getLabel().concat("MultimediaGroup"), (boolean)true, (Class)Units.UNITGROUP);
            if (!unitsByLabel.isEmpty()) {
                UnitGroupRemote multimediaGroup = (UnitGroupRemote)unitsByLabel.get(0);
                this.setMultimediaPowerStateFuture = multimediaGroup.setPowerState(PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build());
            }
        }
        catch (NotAvailableException ex) {
            this.logger.info("MultimediaGroup not available.");
        }
        catch (InterruptedException ex) {
            this.logger.error("Could not get MultimediaGroup!");
        }
        catch (CouldNotPerformException ex) {
            this.logger.error("Could not set Powerstate of MultimediaGroup.");
        }
    }
}

