/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.openbase.bco.dal.remote.unit.TemperatureControllerRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.manager.agent.core.TriggerDAL.AgentTriggerPool;
import org.openbase.bco.manager.agent.core.TriggerJUL.GenericTrigger;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.Observer;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.state.WindowStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.connection.ConnectionConfigType;

public class HeaterEnergySavingAgent
extends AbstractAgentController {
    private LocationRemote locationRemote;
    private Future<ActionFutureType.ActionFuture> setTemperatureFuture;
    private Map<UnitConfigType.UnitConfig, TemperatureStateType.TemperatureState> previousTemperatureState;
    private final Observer<ActivationStateType.ActivationState> triggerHolderObserver;
    private final WindowStateType.WindowState.State triggerState = WindowStateType.WindowState.State.OPEN;

    public HeaterEnergySavingAgent() throws InstantiationException {
        super(HeaterEnergySavingAgent.class);
        this.triggerHolderObserver = (source, data) -> {
            if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.regulateHeater();
            } else if (this.setTemperatureFuture != null) {
                this.setTemperatureFuture.cancel(true);
                this.restoreTemperatureState();
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            super.init(config);
            try {
                this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
            }
            catch (NotAvailableException ex) {
                throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
            }
            for (ConnectionRemote connectionRemote : this.locationRemote.getConnectionList(true)) {
                if (!((UnitConfigType.UnitConfig)connectionRemote.getConfig()).getConnectionConfig().getType().equals((Object)ConnectionConfigType.ConnectionConfig.ConnectionType.WINDOW)) continue;
                try {
                    GenericTrigger trigger = new GenericTrigger(connectionRemote, this.triggerState, ServiceTemplateType.ServiceTemplate.ServiceType.WINDOW_STATE_SERVICE);
                    this.agentTriggerHolder.addTrigger(trigger, AgentTriggerPool.TriggerOperation.OR);
                }
                catch (CouldNotPerformException ex) {
                    throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
                }
            }
            this.agentTriggerHolder.registerObserver(this.triggerHolderObserver);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not initialize Agent.", (Throwable)ex);
        }
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.previousTemperatureState = new HashMap<UnitConfigType.UnitConfig, TemperatureStateType.TemperatureState>();
        this.agentTriggerHolder.activate();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.agentTriggerHolder.deactivate();
    }

    public void shutdown() {
        this.agentTriggerHolder.deregisterObserver(this.triggerHolderObserver);
        this.agentTriggerHolder.shutdown();
        super.shutdown();
    }

    private void regulateHeater() {
        try {
            for (UnitConfigType.UnitConfig temperatureControllerConfig : Registries.getLocationRegistry().getUnitConfigsByLocationLabel(UnitTemplateType.UnitTemplate.UnitType.TEMPERATURE_CONTROLLER, this.locationRemote.getLabel())) {
                try {
                    this.previousTemperatureState.put(temperatureControllerConfig, ((TemperatureControllerRemote)Units.getUnit((UnitConfigType.UnitConfig)temperatureControllerConfig, (boolean)true, (Class)Units.TEMPERATURE_CONTROLLER)).getTargetTemperatureState());
                }
                catch (InterruptedException | NotAvailableException ex) {
                    this.logger.error("Could not set targetTemperatureState of [ " + temperatureControllerConfig.getId() + "]");
                }
            }
        }
        catch (InterruptedException | CouldNotPerformException ex) {
            this.logger.error("Could not get TemperatureControllerConfigs.");
        }
        try {
            this.setTemperatureFuture = this.locationRemote.setTargetTemperatureState(TemperatureStateType.TemperatureState.newBuilder().setTemperature(13.0).build());
        }
        catch (CouldNotPerformException ex) {
            this.logger.error("Could not set targetTemperatureState.");
        }
    }

    private void restoreTemperatureState() {
        if (!this.previousTemperatureState.isEmpty()) {
            for (Map.Entry<UnitConfigType.UnitConfig, TemperatureStateType.TemperatureState> entry : this.previousTemperatureState.entrySet()) {
                try {
                    ((TemperatureControllerRemote)Units.getUnit((UnitConfigType.UnitConfig)entry.getKey(), (boolean)true, (Class)Units.TEMPERATURE_CONTROLLER)).setTargetTemperatureState(entry.getValue());
                }
                catch (InterruptedException | CouldNotPerformException ex) {
                    this.logger.error("Could not set targetTemperatureState of [ " + entry.getKey().getId() + "]");
                }
            }
        }
    }
}

