/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.List;
import java.util.concurrent.Future;
import org.openbase.bco.dal.remote.unit.UnitGroupRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.manager.agent.core.TriggerDAL.AgentTriggerPool;
import org.openbase.bco.manager.agent.core.TriggerDAL.IlluminanceDualBoundaryTrigger;
import org.openbase.bco.manager.agent.core.TriggerJUL.GenericValueDualBoundaryTrigger;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.openbase.jul.pattern.Observer;
import rst.domotic.action.ActionFutureType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class IlluminationLightSavingAgent
extends AbstractAgentController {
    private static final int SLEEP_MILLI = 1000;
    public static final String MINIMUM_NEEDED_KEY = "MINIMUM_ILLUMINATION";
    public static final String MAXIMUM_WANTED_KEY = "MAXIMUM_ILLUMINATION";
    private static double MINIMUM_NEEDED_ILLUMINATION = 2000.0;
    private static double MAXIMUM_WANTED_ILLUMINATION = 4000.0;
    private LocationRemote locationRemote;
    private Future<ActionFutureType.ActionFuture> setPowerStateFutureAmbient;
    private Future<ActionFutureType.ActionFuture> setPowerStateFuture;
    private final Observer<ActivationStateType.ActivationState> triggerHolderObserver = (source, data) -> {
        switch (data.getValue()) {
            case ACTIVE: {
                this.regulateLightIntensity();
                break;
            }
            case DEACTIVE: {
                this.deallocateResourceIteratively();
                break;
            }
            case UNKNOWN: {
                if (this.setPowerStateFuture != null && !this.setPowerStateFuture.isDone()) {
                    this.setPowerStateFuture.cancel(true);
                }
                if (this.setPowerStateFutureAmbient == null || this.setPowerStateFutureAmbient.isDone()) break;
                this.setPowerStateFutureAmbient.cancel(true);
            }
        }
    };

    public IlluminationLightSavingAgent() throws InstantiationException {
        super(IlluminationLightSavingAgent.class);
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.logger.debug("Initializing IlluminationLightSavingAgent[" + config.getLabel() + "]");
            CachedUnitRegistryRemote.waitForData();
            MetaConfigVariableProvider configVariableProvider = new MetaConfigVariableProvider("IlluminationLightSavingAgent", config.getMetaConfig());
            int minimumNeededMeta = -1;
            int maximumWantedMeta = -1;
            try {
                minimumNeededMeta = Integer.parseInt(configVariableProvider.getValue(MINIMUM_NEEDED_KEY));
            }
            catch (CouldNotPerformException couldNotPerformException) {
                // empty catch block
            }
            try {
                maximumWantedMeta = Integer.parseInt(configVariableProvider.getValue(MAXIMUM_WANTED_KEY));
            }
            catch (CouldNotPerformException couldNotPerformException) {
                // empty catch block
            }
            if (minimumNeededMeta != -1) {
                MINIMUM_NEEDED_ILLUMINATION = minimumNeededMeta;
            }
            if (maximumWantedMeta != -1) {
                MAXIMUM_WANTED_ILLUMINATION = maximumWantedMeta;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
        try {
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
        }
        try {
            IlluminanceDualBoundaryTrigger agentTrigger = new IlluminanceDualBoundaryTrigger(this.locationRemote, MAXIMUM_WANTED_ILLUMINATION, MINIMUM_NEEDED_ILLUMINATION, GenericValueDualBoundaryTrigger.TriggerOperation.HIGH_ACTIVE);
            this.agentTriggerHolder.addTrigger(agentTrigger, AgentTriggerPool.TriggerOperation.OR);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
        }
        this.agentTriggerHolder.registerObserver(this.triggerHolderObserver);
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.agentTriggerHolder.activate();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.agentTriggerHolder.deactivate();
        this.logger.info("Deactivated [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
    }

    public void shutdown() {
        this.logger.info("shutdown [Illumination_Light_Saving_Agent_Unit_Test]");
        this.agentTriggerHolder.deregisterObserver(this.triggerHolderObserver);
        this.agentTriggerHolder.shutdown();
        super.shutdown();
        this.logger.info("Finished shutdown [Illumination_Light_Saving_Agent_Unit_Test]");
    }

    private void regulateLightIntensity() throws CouldNotPerformException {
        try {
            List unitsByLabel = Units.getUnitsByLabel((String)this.locationRemote.getLabel().concat("AmbientLightGroup"), (boolean)true, (Class)Units.UNITGROUP);
            if (!unitsByLabel.isEmpty()) {
                UnitGroupRemote ambientLightGroup = (UnitGroupRemote)unitsByLabel.get(0);
                this.setPowerStateFutureAmbient = ambientLightGroup.setPowerState(PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build());
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException | CouldNotPerformException throwable) {
            // empty catch block
        }
        if (this.locationRemote.getIlluminanceState().getIlluminance() > MAXIMUM_WANTED_ILLUMINATION) {
            this.setPowerStateFuture = this.locationRemote.setPowerState(PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT);
        }
    }

    private void deallocateResourceIteratively() throws CouldNotPerformException {
        if (this.setPowerStateFuture != null && !this.setPowerStateFuture.isDone()) {
            this.setPowerStateFuture.cancel(true);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.locationRemote.getIlluminanceState().getIlluminance() < MINIMUM_NEEDED_ILLUMINATION && this.setPowerStateFutureAmbient != null && !this.setPowerStateFutureAmbient.isDone()) {
            this.setPowerStateFutureAmbient.cancel(true);
        }
    }
}

