/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.List;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.manager.agent.core.TriggerDAL.AgentTriggerPool;
import org.openbase.bco.manager.agent.core.TriggerDAL.NeighborConnectionPresenceTrigger;
import org.openbase.bco.manager.agent.core.TriggerJUL.GenericTrigger;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.pattern.Observer;
import rst.domotic.action.ActionFutureType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.connection.ConnectionConfigType;

public class NearFieldLightAgent
extends AbstractAgentController {
    private LocationRemote locationRemote;
    private Future<ActionFutureType.ActionFuture> setBrightnessStateFuture;
    private boolean isDimmed = false;
    private List<LocationRemote> neighborRemotes;
    private final Observer<ActivationStateType.ActivationState> triggerHolderObserver = (source, data) -> {
        if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
            this.dimmLights();
        } else if (this.setBrightnessStateFuture != null) {
            this.setBrightnessStateFuture.cancel(true);
            this.isDimmed = false;
        }
    };

    public NearFieldLightAgent() throws InstantiationException {
        super(NearFieldLightAgent.class);
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            super.init(config);
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
            this.neighborRemotes = this.locationRemote.getNeighborLocationList(true);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"LocationRemote not available", (Throwable)ex);
        }
        try {
            for (LocationRemote neigborRemote : this.neighborRemotes) {
                if (this.locationRemote.hasDirectConnection(neigborRemote.getId(), ConnectionConfigType.ConnectionConfig.ConnectionType.PASSAGE, true)) {
                    GenericTrigger trigger = new GenericTrigger(neigborRemote, PresenceStateType.PresenceState.State.PRESENT, ServiceTemplateType.ServiceTemplate.ServiceType.PRESENCE_STATE_SERVICE);
                    this.agentTriggerHolder.addTrigger(trigger, AgentTriggerPool.TriggerOperation.OR);
                    continue;
                }
                for (ConnectionRemote relatedConnection : this.locationRemote.getDirectConnectionList(neigborRemote.getId(), true)) {
                    NeighborConnectionPresenceTrigger trigger = new NeighborConnectionPresenceTrigger(neigborRemote, relatedConnection);
                    this.agentTriggerHolder.addTrigger(trigger, AgentTriggerPool.TriggerOperation.OR);
                }
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not initialize trigger", (Throwable)ex);
        }
        this.agentTriggerHolder.registerObserver(this.triggerHolderObserver);
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.agentTriggerHolder.activate();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.agentTriggerHolder.deactivate();
    }

    public void shutdown() {
        this.agentTriggerHolder.deregisterObserver(this.triggerHolderObserver);
        this.agentTriggerHolder.shutdown();
        super.shutdown();
    }

    private void dimmLights() {
        if (this.isDimmed) {
            return;
        }
        try {
            this.setBrightnessStateFuture = this.locationRemote.setBrightnessState(BrightnessStateType.BrightnessState.newBuilder().setBrightness(0.5).build());
        }
        catch (CouldNotPerformException ex) {
            Logger.getLogger(NearFieldLightAgent.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.isDimmed = true;
    }
}

