/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.TriggerDAL;

import com.google.protobuf.MessageOrBuilder;
import org.openbase.bco.manager.agent.core.TriggerJUL.AbstractTrigger;
import org.openbase.bco.ontology.lib.trigger.Trigger;
import org.openbase.bco.ontology.lib.trigger.TriggerFactory;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.iface.Manageable;
import org.openbase.jul.pattern.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.ontology.TriggerConfigType;
import rst.domotic.state.ActivationStateType;

public class OntologyTrigger
extends AbstractTrigger
implements Manageable<TriggerConfigType.TriggerConfig> {
    private Trigger trigger;
    private final Observer<ActivationStateType.ActivationState.State> triggerObserver = (source, data) -> this.notifyChange((ActivationStateType.ActivationState)TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)ActivationStateType.ActivationState.newBuilder().setValue(data).build()));

    public void init(TriggerConfigType.TriggerConfig config) throws InitializationException, InterruptedException {
        try {
            TriggerFactory triggerFactory = new TriggerFactory();
            this.trigger = triggerFactory.newInstance((Object)config);
            this.trigger.addObserver(this.triggerObserver);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not initialize OntologyTrigger", (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.trigger.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.trigger.deactivate();
    }

    public boolean isActive() {
        return this.trigger.isActive();
    }

    @Override
    public void shutdown() {
        this.trigger.removeObserver(this.triggerObserver);
        try {
            this.deactivate();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((String)("Could not shutdown " + this), (Throwable)ex, (Logger)LoggerFactory.getLogger(this.getClass()));
        }
        super.shutdown();
    }
}

