/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.concurrent.Future;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.openbase.jul.pattern.Observer;
import rst.domotic.action.ActionFutureType;
import rst.domotic.state.BlindStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.location.LocationDataType;

public class IlluminationRollerShutterAgent
extends AbstractAgentController {
    private static final int SLEEP_MILLI = 1000;
    public static final String MINIMUM_NEEDED_KEY = "MINIMUM_ILLUMINATION";
    public static final String MAXIMUM_WANTED_KEY = "MAXIMUM_ILLUMINATION";
    private static double MINIMUM_NEEDED_ILLUMINATION = 20000.0;
    private static double MAXIMUM_WANTED_ILLUMINATION = 40000.0;
    private LocationRemote locationRemote;
    private Future<ActionFutureType.ActionFuture> setBlindStateFuture;
    private final Observer<LocationDataType.LocationData> locationObserver = (source, data) -> {
        if (data.getIlluminanceState().getIlluminance() > MAXIMUM_WANTED_ILLUMINATION) {
            if (this.regulatedUp) {
                if (this.setBlindStateFuture != null && !this.setBlindStateFuture.isDone()) {
                    this.setBlindStateFuture.cancel(true);
                }
                this.regulatedUp = false;
            }
            if (!this.regulatedDown) {
                this.regulateShutterLevelDown();
            }
        } else if (data.getIlluminanceState().getIlluminance() < MINIMUM_NEEDED_ILLUMINATION) {
            if (this.regulatedDown) {
                if (this.setBlindStateFuture != null && !this.setBlindStateFuture.isDone()) {
                    this.setBlindStateFuture.cancel(true);
                }
                this.regulatedDown = false;
            }
            if (!this.regulatedUp) {
                this.regulateShutterLevelUp();
            }
        } else if ((this.regulatedDown || this.regulatedUp) && this.setBlindStateFuture != null && !this.setBlindStateFuture.isDone()) {
            this.setBlindStateFuture.cancel(true);
        }
    };
    private boolean regulatedDown = false;
    private boolean regulatedUp = false;

    public IlluminationRollerShutterAgent() throws InstantiationException {
        super(IlluminationRollerShutterAgent.class);
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.logger.debug("Initializing IlluminationRollerShutterAgent[" + config.getLabel() + "]");
            CachedUnitRegistryRemote.waitForData();
            MetaConfigVariableProvider configVariableProvider = new MetaConfigVariableProvider("IlluminationRollerShutterAgent", config.getMetaConfig());
            int minimumNeededMeta = -1;
            int maximumWantedMeta = -1;
            try {
                minimumNeededMeta = Integer.parseInt(configVariableProvider.getValue(MINIMUM_NEEDED_KEY));
            }
            catch (CouldNotPerformException couldNotPerformException) {
                // empty catch block
            }
            try {
                maximumWantedMeta = Integer.parseInt(configVariableProvider.getValue(MAXIMUM_WANTED_KEY));
            }
            catch (CouldNotPerformException couldNotPerformException) {
                // empty catch block
            }
            if (minimumNeededMeta != -1) {
                MINIMUM_NEEDED_ILLUMINATION = minimumNeededMeta;
            }
            if (maximumWantedMeta != -1) {
                MAXIMUM_WANTED_ILLUMINATION = maximumWantedMeta;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        this.locationRemote.addDataObserver(this.locationObserver);
        this.locationRemote.waitForData();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.locationRemote.removeDataObserver(this.locationObserver);
    }

    private void regulateShutterLevelDown() throws CouldNotPerformException {
        BlindStateType.BlindState blindState = BlindStateType.BlindState.newBuilder().setMovementState(BlindStateType.BlindState.MovementState.DOWN).build();
        this.setBlindStateFuture = this.locationRemote.setBlindState(blindState);
        while (this.locationRemote.getIlluminanceState().getIlluminance() > MAXIMUM_WANTED_ILLUMINATION && !this.setBlindStateFuture.isDone() && this.locationRemote.getBlindState().getOpeningRatio() != 0.0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        blindState = BlindStateType.BlindState.newBuilder().setMovementState(BlindStateType.BlindState.MovementState.STOP).build();
        this.locationRemote.setBlindState(blindState);
        this.regulatedDown = true;
    }

    private void regulateShutterLevelUp() throws CouldNotPerformException {
        BlindStateType.BlindState blindState = BlindStateType.BlindState.newBuilder().setMovementState(BlindStateType.BlindState.MovementState.UP).build();
        this.setBlindStateFuture = this.locationRemote.setBlindState(blindState);
        while (this.locationRemote.getIlluminanceState().getIlluminance() < MINIMUM_NEEDED_ILLUMINATION && !this.setBlindStateFuture.isDone() && this.locationRemote.getBlindState().getOpeningRatio() != 100.0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        blindState = BlindStateType.BlindState.newBuilder().setMovementState(BlindStateType.BlindState.MovementState.STOP).build();
        this.setBlindStateFuture = this.locationRemote.setBlindState(blindState);
        this.regulatedUp = true;
    }
}

