/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.pattern.Observer;
import rst.domotic.action.ActionFutureType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.location.LocationDataType;

public class RandomLightPatternAgent
extends AbstractAgentController {
    private LocationRemote locationRemote;
    private boolean present = false;
    private Thread thread;
    private final Observer<LocationDataType.LocationData> locationObserver = (source, data) -> {
        if (data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.PRESENT) && !this.present) {
            this.stopRandomLightPattern();
            this.present = true;
        } else if (!data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.PRESENT) && this.present) {
            this.present = false;
            this.makeRandomLightPattern();
        }
    };

    public RandomLightPatternAgent() throws InstantiationException {
        super(RandomLightPatternAgent.class);
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        this.locationRemote.addDataObserver(this.locationObserver);
        this.locationRemote.waitForData();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((Object)((Object)this)).getClass().getSimpleName() + "]");
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.locationRemote.removeDataObserver(this.locationObserver);
    }

    private void makeRandomLightPattern() throws CouldNotPerformException {
        this.thread = new PersonSimulator();
        this.thread.start();
    }

    private void stopRandomLightPattern() throws CouldNotPerformException {
        this.thread.interrupt();
    }

    private class PersonSimulator
    extends Thread {
        private Future<ActionFutureType.ActionFuture> setPowerStateOn;
        private Future<ActionFutureType.ActionFuture> setPowerStateOff;

        private PersonSimulator() {
        }

        @Override
        public void run() {
            try {
                List childLocationList = RandomLightPatternAgent.this.locationRemote.getChildLocationList(true);
                LocationRemote currentLocation = (LocationRemote)childLocationList.get(ThreadLocalRandom.current().nextInt(childLocationList.size()));
                while (true) {
                    this.setPowerStateOn = currentLocation.setPowerState(PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.ON).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT);
                    this.setPowerStateOn.get();
                    this.setPowerStateOff = currentLocation.setPowerState(PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT);
                    this.setPowerStateOff.get();
                    List neighborLocationList = currentLocation.getNeighborLocationList(true);
                    currentLocation = (LocationRemote)neighborLocationList.get(ThreadLocalRandom.current().nextInt(neighborLocationList.size()));
                }
            }
            catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
                Logger.getLogger(RandomLightPatternAgent.class.getName()).log(Level.SEVERE, null, ex);
                this.interrupt();
                return;
            }
        }

        @Override
        public void interrupt() {
            this.setPowerStateOn.cancel(true);
            this.setPowerStateOff.cancel(true);
            super.interrupt();
        }
    }
}

