/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core;

import java.util.concurrent.TimeUnit;
import org.openbase.bco.manager.agent.core.AgentFactoryImpl;
import org.openbase.bco.manager.agent.lib.AgentController;
import org.openbase.bco.manager.agent.lib.AgentFactory;
import org.openbase.bco.manager.agent.lib.AgentManager;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.ControllerRegistryImpl;
import org.openbase.jul.storage.registry.EnableableEntryRegistrySynchronizer;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;

public class AgentManagerController
implements AgentManager,
Launchable<Void>,
VoidInitializable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AgentManagerController.class);
    private final AgentFactory factory;
    private final ControllerRegistryImpl<String, AgentController> agentRegistry;
    private final EnableableEntryRegistrySynchronizer<String, AgentController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> agentRegistrySynchronizer;

    public AgentManagerController() throws InstantiationException, InterruptedException {
        try {
            this.factory = AgentFactoryImpl.getInstance();
            this.agentRegistry = new ControllerRegistryImpl();
            this.agentRegistrySynchronizer = new EnableableEntryRegistrySynchronizer<String, AgentController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>(this.agentRegistry, (RemoteRegistry)Registries.getAgentRegistry().getAgentConfigRemoteRegistry(), (Factory)this.factory){

                public boolean enablingCondition(UnitConfigType.UnitConfig config) {
                    return config.getEnablingState().getValue() == EnablingStateType.EnablingState.State.ENABLED;
                }
            };
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void init() throws InitializationException, InterruptedException {
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        Registries.waitForData();
        this.agentRegistrySynchronizer.activate();
    }

    public boolean isActive() {
        return this.agentRegistrySynchronizer.isActive();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.agentRegistrySynchronizer.deactivate();
    }

    public void shutdown() {
        this.agentRegistrySynchronizer.shutdown();
    }

    public void waitForInit(long timeout, TimeUnit timeUnit) throws CouldNotPerformException, InterruptedException {
        Registries.getAgentRegistry().waitForData(timeout, timeUnit);
    }
}

