/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.action.ActionRescheduler;
import org.openbase.bco.dal.remote.trigger.GenericBCOTrigger;
import org.openbase.bco.dal.remote.trigger.preset.NeighborConnectionPresenceTrigger;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.connection.ConnectionRemote;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.preset.AbstractResourceAllocationAgent;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.openbase.jul.pattern.trigger.TriggerPool;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.connection.ConnectionConfigType;

public class NearFieldLightAgent
extends AbstractResourceAllocationAgent {
    private LocationRemote locationRemote;
    private List<LocationRemote> neighborRemotes;

    public NearFieldLightAgent() throws InstantiationException {
        super(NearFieldLightAgent.class);
        this.actionRescheduleHelper = new ActionRescheduler(ActionRescheduler.RescheduleOption.EXTEND, 30L);
        this.triggerHolderObserver = (source, data) -> {
            if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.dimmLights();
            } else {
                this.actionRescheduleHelper.stopExecution();
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            super.init(config);
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
            this.neighborRemotes = this.locationRemote.getNeighborLocationList(true);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"LocationRemote not available", (Throwable)ex);
        }
        try {
            for (LocationRemote neigborRemote : this.neighborRemotes) {
                if (this.locationRemote.hasDirectConnection(neigborRemote.getId(), ConnectionConfigType.ConnectionConfig.ConnectionType.PASSAGE, true)) {
                    GenericBCOTrigger trigger = new GenericBCOTrigger((AbstractUnitRemote)neigborRemote, (Enum)PresenceStateType.PresenceState.State.PRESENT, ServiceTemplateType.ServiceTemplate.ServiceType.PRESENCE_STATE_SERVICE);
                    this.agentTriggerHolder.addTrigger((AbstractTrigger)trigger, TriggerPool.TriggerOperation.OR);
                    continue;
                }
                for (ConnectionRemote relatedConnection : this.locationRemote.getDirectConnectionList(neigborRemote.getId(), true)) {
                    NeighborConnectionPresenceTrigger trigger = new NeighborConnectionPresenceTrigger(neigborRemote, relatedConnection);
                    this.agentTriggerHolder.addTrigger((AbstractTrigger)trigger, TriggerPool.TriggerOperation.OR);
                }
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not initialize trigger", (Throwable)ex);
        }
    }

    private void dimmLights() {
        try {
            ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)this.locationRemote, BrightnessStateType.BrightnessState.newBuilder().setBrightness(0.5).build(), UnitTemplateType.UnitTemplate.UnitType.DIMMABLE_LIGHT, ServiceTemplateType.ServiceTemplate.ServiceType.BRIGHTNESS_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
            this.actionRescheduleHelper.startActionRescheduleing(((ActionFutureType.ActionFuture)this.locationRemote.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
        }
        catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
            this.logger.error("Could not dim lights.", ex);
        }
    }
}

