/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import rst.domotic.state.EnablingStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;
import rst.rsb.ScopeType;

public class PowerStateSynchroniserAgent
extends AbstractAgentController {
    public static final String SOURCE_KEY = "SOURCE";
    public static final String TARGET_KEY = "TARGET";
    public static final String SOURCE_BEHAVIOUR_KEY = "SOURCE_BEHAVIOUR";
    public static final String TARGET_BEHAVIOUR_KEY = "TARGET_BEHAVIOUR";
    private final Object AGENT_LOCK = new SyncObject("PowerStateLock");
    private static final PowerStateType.PowerState ON = PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.ON).build();
    private static final PowerStateType.PowerState OFF = PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build();
    private PowerStateType.PowerState.State sourceLatestPowerState;
    private final List<UnitRemote> targetRemotes = new ArrayList<UnitRemote>();
    private final Observer<GeneratedMessage> sourceObserver = (source, data) -> this.handleSourcePowerStateUpdate(this.invokeGetPowerState(data).getValue(), source);
    private final Observer<GeneratedMessage> targetObserver = (source, data) -> this.handleTargetPowerStateUpdate(this.invokeGetPowerState(data).getValue(), source);
    private PowerStateType.PowerState.State targetLatestPowerState;
    private UnitRemote sourceRemote;
    private PowerStateSyncBehaviour sourceBehaviour;
    private PowerStateSyncBehaviour targetBehaviour;

    public PowerStateSynchroniserAgent() throws InstantiationException, CouldNotPerformException {
        super(PowerStateSynchroniserAgent.class);
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.logger.debug("Initializing PowerStateSynchroniserAgent[" + config.getLabel() + "]");
            Registries.getUnitRegistry().waitForData();
            MetaConfigVariableProvider configVariableProvider = new MetaConfigVariableProvider("PowerStateSynchroniserAgent", config.getMetaConfig());
            UnitConfigType.UnitConfig sourceUnitConfig = Registries.getUnitRegistry().getUnitConfigById(configVariableProvider.getValue(SOURCE_KEY));
            if (sourceUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                throw new NotAvailableException("Source[" + ScopeGenerator.generateStringRep((ScopeType.Scope)sourceUnitConfig.getScope()) + "] is not enabled");
            }
            this.sourceRemote = Units.getUnit((UnitConfigType.UnitConfig)sourceUnitConfig, (boolean)false);
            int i = 1;
            try {
                String unitId;
                while (!(unitId = configVariableProvider.getValue("TARGET_" + i)).isEmpty()) {
                    this.logger.debug("Found target id [" + unitId + "] with key [" + TARGET_KEY + "_" + ++i + "]");
                    UnitConfigType.UnitConfig targetUnitConfig = CachedUnitRegistryRemote.getRegistry().getUnitConfigById(unitId);
                    if (targetUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                        this.logger.warn("TargetUnit[" + ScopeGenerator.generateStringRep((ScopeType.Scope)targetUnitConfig.getScope()) + "] of powerStateSynchroniserAgent[" + ScopeGenerator.generateStringRep((ScopeType.Scope)config.getScope()) + "] is disabled and therefore skipped!");
                        continue;
                    }
                    this.targetRemotes.add(Units.getUnit((String)unitId, (boolean)false));
                }
            }
            catch (NotAvailableException ex) {
                this.logger.debug("Found [" + --i + "] target/s");
            }
            this.sourceBehaviour = PowerStateSyncBehaviour.valueOf(configVariableProvider.getValue(SOURCE_BEHAVIOUR_KEY));
            this.targetBehaviour = PowerStateSyncBehaviour.valueOf(configVariableProvider.getValue(TARGET_BEHAVIOUR_KEY));
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetPowerStateUpdate(PowerStateType.PowerState.State targetPowerState, Object target) {
        Object object = this.AGENT_LOCK;
        synchronized (object) {
            try {
                this.logger.debug("Received new Value[" + targetPowerState + "] for Target[" + target + "]");
                if (!this.updateLatestTargetPowerState(targetPowerState, target)) {
                    return;
                }
                if (this.targetLatestPowerState == PowerStateType.PowerState.State.ON) {
                    if (this.sourceLatestPowerState != PowerStateType.PowerState.State.ON) {
                        this.invokeSetPower(this.sourceRemote, ON);
                    }
                } else if (this.targetLatestPowerState == PowerStateType.PowerState.State.OFF) {
                    switch (this.sourceBehaviour) {
                        case OFF: {
                            if (this.sourceLatestPowerState == PowerStateType.PowerState.State.OFF) break;
                            this.invokeSetPower(this.sourceRemote, OFF);
                            break;
                        }
                        case ON: {
                            if (this.sourceLatestPowerState == PowerStateType.PowerState.State.ON) break;
                            this.invokeSetPower(this.sourceRemote, ON);
                            break;
                        }
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle target power state update!", (Throwable)ex, (Logger)this.logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSourcePowerStateUpdate(PowerStateType.PowerState.State sourcePowerState, Object target) {
        Object object = this.AGENT_LOCK;
        synchronized (object) {
            this.sourceLatestPowerState = sourcePowerState;
            this.logger.debug("Handle new Value[" + sourcePowerState + "] for Source[" + target + "]");
            if (this.sourceLatestPowerState == PowerStateType.PowerState.State.OFF) {
                if (this.targetLatestPowerState != PowerStateType.PowerState.State.OFF) {
                    this.targetRemotes.stream().forEach(targetRemote -> this.invokeSetPower((UnitRemote)targetRemote, OFF));
                }
            } else if (this.sourceLatestPowerState == PowerStateType.PowerState.State.ON) {
                switch (this.targetBehaviour) {
                    case OFF: {
                        if (this.targetLatestPowerState == PowerStateType.PowerState.State.OFF) break;
                        this.targetRemotes.stream().forEach(targetRemote -> this.invokeSetPower((UnitRemote)targetRemote, OFF));
                        break;
                    }
                    case ON: {
                        if (this.targetLatestPowerState == PowerStateType.PowerState.State.ON) break;
                        this.targetRemotes.stream().forEach(targetRemote -> this.invokeSetPower((UnitRemote)targetRemote, ON));
                        break;
                    }
                }
            }
        }
    }

    private boolean updateLatestTargetPowerState(PowerStateType.PowerState.State targetPowerState, Object source) throws CouldNotPerformException {
        this.logger.debug("Received new Value[" + targetPowerState + "] for Source[" + source + "]");
        if (this.targetLatestPowerState == PowerStateType.PowerState.State.UNKNOWN) {
            this.targetLatestPowerState = targetPowerState;
            return true;
        }
        if (this.targetLatestPowerState == PowerStateType.PowerState.State.OFF && targetPowerState == PowerStateType.PowerState.State.ON) {
            this.targetLatestPowerState = PowerStateType.PowerState.State.ON;
            return true;
        }
        if (this.targetLatestPowerState == PowerStateType.PowerState.State.ON && targetPowerState == PowerStateType.PowerState.State.OFF) {
            this.targetLatestPowerState = PowerStateType.PowerState.State.OFF;
            for (UnitRemote targetRemote : this.targetRemotes) {
                if (this.invokeGetPowerState(targetRemote.getData()).getValue() != PowerStateType.PowerState.State.ON) continue;
                this.targetLatestPowerState = PowerStateType.PowerState.State.ON;
                break;
            }
            return this.targetLatestPowerState == PowerStateType.PowerState.State.OFF;
        }
        return false;
    }

    private void invokeSetPower(UnitRemote remote, PowerStateType.PowerState powerState) {
        this.logger.debug("Switch " + remote + " to " + powerState.getValue().name());
        try {
            Method method = remote.getClass().getMethod("setPowerState", PowerStateType.PowerState.class);
            method.invoke((Object)remote, powerState);
        }
        catch (NoSuchMethodException ex) {
            ExceptionPrinter.printHistory((String)("Remote [" + remote.getClass().getSimpleName() + "] has no set Power method!"), (Throwable)ex, (Logger)this.logger);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            ExceptionPrinter.printHistory((String)("Could not invoke setPower method on remote [" + remote.getClass().getSimpleName() + "] with value [" + powerState + "]"), (Throwable)ex, (Logger)this.logger);
        }
    }

    private PowerStateType.PowerState invokeGetPowerState(Object message) throws CouldNotPerformException {
        try {
            Method method = message.getClass().getMethod("getPowerState", new Class[0]);
            return (PowerStateType.PowerState)method.invoke(message, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw new CouldNotPerformException("Could not get powerState from message [" + message + "]", (Throwable)ex);
        }
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Executing PowerStateSynchroniser agent");
        this.sourceRemote.waitForData();
        String targetIds = "";
        this.targetLatestPowerState = PowerStateType.PowerState.State.UNKNOWN;
        for (UnitRemote targetRemote : this.targetRemotes) {
            targetRemote.waitForData();
            targetIds = targetIds + "[" + targetRemote.getLabel() + "]";
            if ((this.targetLatestPowerState == PowerStateType.PowerState.State.OFF || this.targetLatestPowerState == PowerStateType.PowerState.State.UNKNOWN) && this.invokeGetPowerState(targetRemote.getData()).getValue() == PowerStateType.PowerState.State.ON) {
                this.targetLatestPowerState = PowerStateType.PowerState.State.ON;
            } else if (this.targetLatestPowerState == PowerStateType.PowerState.State.UNKNOWN && this.invokeGetPowerState(targetRemote.getData()).getValue() == PowerStateType.PowerState.State.OFF) {
                this.targetLatestPowerState = PowerStateType.PowerState.State.OFF;
            }
            targetRemote.addDataObserver(this.targetObserver);
            this.handleTargetPowerStateUpdate(this.invokeGetPowerState(targetRemote.getData()).getValue(), targetRemote);
        }
        this.sourceRemote.addDataObserver(this.sourceObserver);
        this.handleSourcePowerStateUpdate(this.invokeGetPowerState(this.sourceRemote.getData()).getValue(), this.sourceRemote);
        this.logger.debug("Source [" + this.sourceRemote.getLabel() + "] behaviour [" + (Object)((Object)this.sourceBehaviour) + "]");
        this.logger.debug("Targets [" + targetIds + "] behaviour [" + (Object)((Object)this.targetBehaviour) + "]");
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Stopping PowerStateSynchroniserAgent...");
        this.sourceRemote.removeDataObserver(this.sourceObserver);
        for (UnitRemote targetRemote : this.targetRemotes) {
            targetRemote.removeDataObserver(this.sourceObserver);
        }
    }

    public UnitRemote getSourceRemote() {
        return this.sourceRemote;
    }

    public List<UnitRemote> getTargetRemotes() {
        return this.targetRemotes;
    }

    public PowerStateSyncBehaviour getSourceBehaviour() {
        return this.sourceBehaviour;
    }

    public PowerStateSyncBehaviour getTargetBehaviour() {
        return this.targetBehaviour;
    }

    public static enum PowerStateSyncBehaviour {
        ON,
        OFF,
        LAST_STATE;

    }
}

