/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.MessageOrBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.action.ActionRescheduler;
import org.openbase.bco.dal.remote.trigger.GenericBCOTrigger;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.TemperatureControllerRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.preset.AbstractResourceAllocationAgent;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.openbase.jul.pattern.trigger.TriggerPool;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class TemperatureControllerAgent
extends AbstractResourceAllocationAgent {
    private LocationRemote locationRemote;
    private final Map<TemperatureControllerRemote, TemperatureStateType.TemperatureState> previousTemperatureState;
    private final PresenceStateType.PresenceState.State triggerState = PresenceStateType.PresenceState.State.ABSENT;

    public TemperatureControllerAgent() throws InstantiationException {
        super(TemperatureControllerAgent.class);
        this.previousTemperatureState = new HashMap<TemperatureControllerRemote, TemperatureStateType.TemperatureState>();
        this.actionRescheduleHelper = new ActionRescheduler(ActionRescheduler.RescheduleOption.EXTEND, 30L);
        this.triggerHolderObserver = (source, data) -> {
            if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.regulateTemperature();
            } else {
                this.actionRescheduleHelper.stopExecution();
                this.restoreTemperature();
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            super.init(config);
            try {
                this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
            }
            catch (NotAvailableException ex) {
                throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
            }
            try {
                GenericBCOTrigger agentTrigger = new GenericBCOTrigger((AbstractUnitRemote)this.locationRemote, (Enum)this.triggerState, ServiceTemplateType.ServiceTemplate.ServiceType.PRESENCE_STATE_SERVICE);
                this.agentTriggerHolder.addTrigger((AbstractTrigger)agentTrigger, TriggerPool.TriggerOperation.OR);
            }
            catch (CouldNotPerformException ex) {
                throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not initialize Agent.", (Throwable)ex);
        }
    }

    private void regulateTemperature() {
        this.previousTemperatureState.clear();
        try {
            for (TemperatureControllerRemote remote : this.locationRemote.getUnits(UnitTemplateType.UnitTemplate.UnitType.TEMPERATURE_CONTROLLER, true, Units.TEMPERATURE_CONTROLLER)) {
                this.previousTemperatureState.put(remote, remote.getTargetTemperatureState());
            }
        }
        catch (InterruptedException | CouldNotPerformException ex) {
            this.logger.error("Could not get all TemperatureControllerRemotes.", ex);
        }
        try {
            ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)this.locationRemote, TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)TemperatureStateType.TemperatureState.newBuilder().setTemperature(13.0).build()), UnitTemplateType.UnitTemplate.UnitType.TEMPERATURE_CONTROLLER, ServiceTemplateType.ServiceTemplate.ServiceType.TARGET_TEMPERATURE_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
            this.actionRescheduleHelper.startActionRescheduleing(((ActionFutureType.ActionFuture)this.locationRemote.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
        }
        catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
            this.logger.error("Could not set targetTemperatureState.", ex);
        }
    }

    private void restoreTemperature() {
        if (this.previousTemperatureState == null | this.previousTemperatureState.isEmpty()) {
            return;
        }
        this.previousTemperatureState.forEach((remote, temperatureState) -> {
            try {
                ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)remote, TimestampProcessor.updateTimestampWithCurrentTime((MessageOrBuilder)temperatureState), UnitTemplateType.UnitTemplate.UnitType.TEMPERATURE_CONTROLLER, ServiceTemplateType.ServiceTemplate.ServiceType.TARGET_TEMPERATURE_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
                ((ActionFutureType.ActionFuture)remote.applyAction(actionDescriptionBuilder.build()).get()).toBuilder();
            }
            catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
                this.logger.error("Could not restore targetTemperatureState.", ex);
            }
        });
        this.previousTemperatureState.clear();
    }
}

