/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.lib.layer.unit.AbstractExecutableBaseUnitController;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.manager.agent.lib.AgentController;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.protobuf.ClosableDataBuilder;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rst.processing.ActionDescriptionProcessor;
import org.openbase.jul.pattern.trigger.TriggerPool;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.calendar.DateTimeType;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.EmphasisStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.agent.AgentDataType;
import rst.rsb.ScopeType;

public abstract class AbstractAgentController
extends AbstractExecutableBaseUnitController<AgentDataType.AgentData, AgentDataType.AgentData.Builder>
implements AgentController {
    protected TriggerPool agentTriggerHolder = new TriggerPool();

    public AbstractAgentController(Class unitClass) throws InstantiationException {
        super(unitClass, (GeneratedMessage.Builder)AgentDataType.AgentData.newBuilder());
    }

    protected boolean isAutostartEnabled() throws CouldNotPerformException {
        return ((UnitConfigType.UnitConfig)this.getConfig()).getAgentConfig().getAutostart();
    }

    public Future<ActionFutureType.ActionFuture> setEmphasisState(EmphasisStateType.EmphasisState emphasisState) throws CouldNotPerformException {
        this.logger.debug("Apply emphasisState Update[" + emphasisState + "] for " + (Object)((Object)this) + ".");
        try (ClosableDataBuilder dataBuilder = this.getDataBuilder((Object)this);){
            ((AgentDataType.AgentData.Builder)dataBuilder.getInternalBuilder()).setEmphasisState(emphasisState);
        }
        catch (Exception ex) {
            throw new CouldNotPerformException("Could not apply emphasisState Update[" + emphasisState + "] for " + (Object)((Object)this) + "!", (Throwable)ex);
        }
        CompletableFuture<ActionFutureType.ActionFuture> completableFuture = new CompletableFuture<ActionFutureType.ActionFuture>();
        completableFuture.complete(ActionFutureType.ActionFuture.getDefaultInstance());
        return completableFuture;
    }

    public EmphasisStateType.EmphasisState getEmphasisState() throws NotAvailableException {
        return ((AgentDataType.AgentData)this.getData()).getEmphasisState();
    }

    protected ActionDescriptionType.ActionDescription.Builder getNewActionDescription(ActionAuthorityType.ActionAuthority actionAuthority, ResourceAllocationType.ResourceAllocation.Initiator initiator, long executionTimePeriod, ResourceAllocationType.ResourceAllocation.Policy policy, ResourceAllocationType.ResourceAllocation.Priority priority, UnitRemote unitRemote, Object serviceAttribute, UnitTemplateType.UnitTemplate.UnitType unitType, ServiceTemplateType.ServiceTemplate.ServiceType serviceType, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy multiResourceAllocationStrategy) throws CouldNotPerformException {
        ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = ActionDescriptionProcessor.getActionDescription((ActionAuthorityType.ActionAuthority)actionAuthority, (ResourceAllocationType.ResourceAllocation.Initiator)initiator);
        actionDescriptionBuilder.setExecutionTimePeriod(executionTimePeriod);
        if (executionTimePeriod != 0L) {
            DateTimeType.DateTime dateTime = DateTimeType.DateTime.newBuilder().setDateTimeType(DateTimeType.DateTime.Type.FLOATING).setMillisecondsSinceEpoch(System.currentTimeMillis() + executionTimePeriod).build();
            actionDescriptionBuilder.setExecutionValidity(dateTime);
        }
        actionDescriptionBuilder.setMultiResourceAllocationStrategy(MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.newBuilder().setStrategy(multiResourceAllocationStrategy).build());
        ResourceAllocationType.ResourceAllocation.Builder resourceAllocation = actionDescriptionBuilder.getResourceAllocationBuilder();
        resourceAllocation.setPolicy(policy);
        resourceAllocation.setPriority(priority);
        resourceAllocation.addResourceIds(ScopeGenerator.generateStringRep((ScopeType.Scope)unitRemote.getScope()));
        Service.upateActionDescription((ActionDescriptionType.ActionDescription.Builder)actionDescriptionBuilder, (Object)serviceAttribute, (ServiceTemplateType.ServiceTemplate.ServiceType)serviceType);
        ServiceStateDescriptionType.ServiceStateDescription.Builder serviceStateDescription = actionDescriptionBuilder.getServiceStateDescriptionBuilder();
        serviceStateDescription.setUnitId(unitRemote.getId().toString());
        serviceStateDescription.setUnitType(unitType);
        actionDescriptionBuilder.setDescription(actionDescriptionBuilder.getDescription().replace("$LABEL", unitRemote.getLabel()));
        actionDescriptionBuilder.setLabel(actionDescriptionBuilder.getLabel().replace("$LABEL", unitRemote.getLabel()));
        ActionDescriptionProcessor.updateResourceAllocationSlot((ActionDescriptionType.ActionDescription.Builder)actionDescriptionBuilder);
        ActionDescriptionProcessor.updateResourceAllocationId((ActionDescriptionType.ActionDescription.Builder)actionDescriptionBuilder);
        return actionDescriptionBuilder;
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)AgentDataType.AgentData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActivationStateType.ActivationState.getDefaultInstance()));
    }
}

