/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.concurrent.ExecutionException;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.action.ActionRescheduler;
import org.openbase.bco.dal.remote.trigger.GenericBCOTrigger;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.preset.AbstractResourceAllocationAgent;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.openbase.jul.pattern.trigger.TriggerPool;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.AlarmStateType;
import rst.domotic.state.BlindStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class FireAlarmAgent
extends AbstractResourceAllocationAgent {
    private LocationRemote locationRemote;
    private final AlarmStateType.AlarmState.State triggerState = AlarmStateType.AlarmState.State.ALARM;

    public FireAlarmAgent() throws InstantiationException {
        super(FireAlarmAgent.class);
        this.actionRescheduleHelper = new ActionRescheduler(ActionRescheduler.RescheduleOption.EXTEND, 30L);
        this.triggerHolderObserver = (source, data) -> {
            if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.alarmRoutine();
            } else {
                this.actionRescheduleHelper.stopExecution();
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
        }
        try {
            GenericBCOTrigger agentTrigger = new GenericBCOTrigger((AbstractUnitRemote)this.locationRemote, (Enum)this.triggerState, ServiceTemplateType.ServiceTemplate.ServiceType.SMOKE_ALARM_STATE_SERVICE);
            this.agentTriggerHolder.addTrigger((AbstractTrigger)agentTrigger, TriggerPool.TriggerOperation.OR);
            GenericBCOTrigger agentFireTrigger = new GenericBCOTrigger((AbstractUnitRemote)this.locationRemote, (Enum)this.triggerState, ServiceTemplateType.ServiceTemplate.ServiceType.FIRE_ALARM_STATE_SERVICE);
            this.agentTriggerHolder.addTrigger((AbstractTrigger)agentFireTrigger, TriggerPool.TriggerOperation.OR);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
        }
    }

    private void alarmRoutine() {
        try {
            ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.EMERGENCY, (UnitRemote)this.locationRemote, PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.ON).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
            this.actionRescheduleHelper.startActionRescheduleing(((ActionFutureType.ActionFuture)this.locationRemote.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
            actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.EMERGENCY, (UnitRemote)this.locationRemote, BlindStateType.BlindState.newBuilder().setOpeningRatio(100.0).build(), UnitTemplateType.UnitTemplate.UnitType.UNKNOWN, ServiceTemplateType.ServiceTemplate.ServiceType.BLIND_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
            this.actionRescheduleHelper.addRescheduleAction(((ActionFutureType.ActionFuture)this.locationRemote.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
        }
        catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
            this.logger.error("Could not execute alarm routine.", ex);
        }
    }
}

