/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.List;
import java.util.concurrent.ExecutionException;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.action.ActionRescheduler;
import org.openbase.bco.dal.remote.trigger.GenericValueDualBoundaryBCOTrigger;
import org.openbase.bco.dal.remote.trigger.preset.IlluminanceDualBoundaryTrigger;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.dal.remote.unit.unitgroup.UnitGroupRemote;
import org.openbase.bco.manager.agent.core.preset.AbstractResourceAllocationAgent;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.openbase.jul.pattern.trigger.TriggerPool;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class IlluminationLightSavingAgent
extends AbstractResourceAllocationAgent {
    private static final int SLEEP_MILLI = 1000;
    public static final String MINIMUM_NEEDED_KEY = "MINIMUM_ILLUMINATION";
    public static final String MAXIMUM_WANTED_KEY = "MAXIMUM_ILLUMINATION";
    private static double MINIMUM_NEEDED_ILLUMINATION = 2000.0;
    private static double MAXIMUM_WANTED_ILLUMINATION = 4000.0;
    private LocationRemote locationRemote;

    public IlluminationLightSavingAgent() throws InstantiationException {
        super(IlluminationLightSavingAgent.class);
        this.actionRescheduleHelper = new ActionRescheduler(ActionRescheduler.RescheduleOption.EXTEND, 30L);
        this.triggerHolderObserver = (source, data) -> {
            if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.regulateLightIntensity();
            } else {
                this.actionRescheduleHelper.stopExecution();
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.logger.debug("Initializing IlluminationLightSavingAgent[" + config.getLabel() + "]");
            CachedUnitRegistryRemote.waitForData();
            MetaConfigVariableProvider configVariableProvider = new MetaConfigVariableProvider("IlluminationLightSavingAgent", config.getMetaConfig());
            int minimumNeededMeta = -1;
            int maximumWantedMeta = -1;
            try {
                minimumNeededMeta = Integer.parseInt(configVariableProvider.getValue(MINIMUM_NEEDED_KEY));
            }
            catch (CouldNotPerformException couldNotPerformException) {
                // empty catch block
            }
            try {
                maximumWantedMeta = Integer.parseInt(configVariableProvider.getValue(MAXIMUM_WANTED_KEY));
            }
            catch (CouldNotPerformException couldNotPerformException) {
                // empty catch block
            }
            if (minimumNeededMeta != -1) {
                MINIMUM_NEEDED_ILLUMINATION = minimumNeededMeta;
            }
            if (maximumWantedMeta != -1) {
                MAXIMUM_WANTED_ILLUMINATION = maximumWantedMeta;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
        try {
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
        }
        try {
            IlluminanceDualBoundaryTrigger agentTrigger = new IlluminanceDualBoundaryTrigger((AbstractUnitRemote)this.locationRemote, MAXIMUM_WANTED_ILLUMINATION, MINIMUM_NEEDED_ILLUMINATION, GenericValueDualBoundaryBCOTrigger.TriggerOperation.HIGH_ACTIVE);
            this.agentTriggerHolder.addTrigger((AbstractTrigger)agentTrigger, TriggerPool.TriggerOperation.OR);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
        }
    }

    private void regulateLightIntensity() throws CouldNotPerformException {
        try {
            List unitsByLabel = Units.getUnitsByLabel((String)this.locationRemote.getLabel().concat("AmbientLightGroup"), (boolean)true, (Class)Units.UNITGROUP);
            if (!unitsByLabel.isEmpty()) {
                UnitGroupRemote ambientLightGroup = (UnitGroupRemote)unitsByLabel.get(0);
                ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)ambientLightGroup, PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
                this.actionRescheduleHelper.startActionRescheduleing(((ActionFutureType.ActionFuture)ambientLightGroup.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
                Thread.sleep(1000L);
            }
            if (this.locationRemote.getIlluminanceState().getIlluminance() > MAXIMUM_WANTED_ILLUMINATION) {
                this.actionRescheduleHelper.stopExecution();
                ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)this.locationRemote, PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
                this.actionRescheduleHelper.startActionRescheduleing(((ActionFutureType.ActionFuture)this.locationRemote.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
            }
        }
        catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
            this.logger.error("Could not set light intensity.", ex);
        }
    }
}

