/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.List;
import org.openbase.bco.dal.lib.layer.service.Services;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.bco.registry.unit.remote.CachedUnitRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.openbase.jul.extension.rst.processing.MetaConfigVariableProvider;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.service.ServiceTempusTypeType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.EnablingStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;
import rst.rsb.ScopeType;

public class PowerStateSynchroniserAgent
extends AbstractAgentController {
    public static final String SOURCE_KEY = "SOURCE";
    public static final String TARGET_KEY = "TARGET";
    public static final String SOURCE_BEHAVIOUR_KEY = "SOURCE_BEHAVIOUR";
    public static final String TARGET_BEHAVIOUR_KEY = "TARGET_BEHAVIOUR";
    private static final PowerStateType.PowerState ON = PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.ON).build();
    private static final PowerStateType.PowerState OFF = PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build();
    private static final PowerStateSyncBehaviour DEFAULT_SOURCE_BEHAVIOR = PowerStateSyncBehaviour.OFF;
    private static final PowerStateSyncBehaviour DEFAULT_TARGET_BEHAVIOR = PowerStateSyncBehaviour.ON;
    private final Object AGENT_LOCK = new SyncObject("PowerStateLock");
    private PowerStateType.PowerState.State latestPowerStateSource;
    private PowerStateType.PowerState.State latestPowerStateTarget;
    private final Observer<GeneratedMessage> sourceObserver;
    private final Observer<GeneratedMessage> sourceRequestObserver;
    private final Observer<GeneratedMessage> targetObserver;
    private final Observer<GeneratedMessage> targetRequestObserer;
    private final List<UnitRemote> targetRemotes = new ArrayList<UnitRemote>();
    private UnitRemote sourceRemote;
    private PowerStateSyncBehaviour sourceBehaviour;
    private PowerStateSyncBehaviour targetBehaviour;

    public PowerStateSynchroniserAgent() throws CouldNotPerformException {
        super(PowerStateSynchroniserAgent.class);
        this.sourceObserver = (source, data) -> {
            try {
                this.handleSourcePowerStateUpdate(((PowerStateType.PowerState)data).getValue(), source);
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
            }
        };
        this.sourceRequestObserver = (source, data) -> {
            try {
                this.handleSourcePowerStateRequest((PowerStateType.PowerState)data);
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
            }
        };
        this.targetObserver = (source, data) -> {
            try {
                this.handleTargetPowerStateUpdate(((PowerStateType.PowerState)data).getValue());
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
            }
        };
        this.targetRequestObserer = (source, data) -> {
            try {
                this.handleTargetPowerStateRequest((PowerStateType.PowerState)data);
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
            }
        };
    }

    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        boolean active;
        UnitConfigType.UnitConfig unitConfig = super.applyConfigUpdate(config);
        boolean bl = active = this.getActivationState().getValue() == ActivationStateType.ActivationState.State.ACTIVE;
        if (active) {
            this.stop();
        }
        try {
            this.logger.info("ApplyConfigUpdate for PowerStateSynchroniserAgent[" + config.getLabel() + "]");
            Registries.getUnitRegistry().waitForData();
            MetaConfigVariableProvider configVariableProvider = new MetaConfigVariableProvider("PowerStateSynchroniserAgent", config.getMetaConfig());
            UnitConfigType.UnitConfig sourceUnitConfig = Registries.getUnitRegistry().getUnitConfigById(configVariableProvider.getValue(SOURCE_KEY));
            if (sourceUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                throw new NotAvailableException("Source[" + ScopeGenerator.generateStringRep((ScopeType.Scope)sourceUnitConfig.getScope()) + "] is not enabled");
            }
            this.sourceRemote = Units.getUnit((UnitConfigType.UnitConfig)sourceUnitConfig, (boolean)false);
            this.targetRemotes.clear();
            int i = 1;
            try {
                String unitId;
                while (!(unitId = configVariableProvider.getValue("TARGET_" + i)).isEmpty()) {
                    this.logger.debug("Found target id [" + unitId + "] with key [" + TARGET_KEY + "_" + ++i + "]");
                    UnitConfigType.UnitConfig targetUnitConfig = CachedUnitRegistryRemote.getRegistry().getUnitConfigById(unitId);
                    if (targetUnitConfig.getEnablingState().getValue() != EnablingStateType.EnablingState.State.ENABLED) {
                        this.logger.warn("TargetUnit[" + ScopeGenerator.generateStringRep((ScopeType.Scope)targetUnitConfig.getScope()) + "] of powerStateSynchroniserAgent[" + ScopeGenerator.generateStringRep((ScopeType.Scope)config.getScope()) + "] is disabled and therefore skipped!");
                        continue;
                    }
                    this.targetRemotes.add(Units.getUnit((String)unitId, (boolean)false));
                }
            }
            catch (NotAvailableException ex) {
                this.logger.debug("Found [" + --i + "] target/s");
            }
            try {
                this.sourceBehaviour = PowerStateSyncBehaviour.valueOf(configVariableProvider.getValue(SOURCE_BEHAVIOUR_KEY));
            }
            catch (NotAvailableException ex) {
                this.sourceBehaviour = DEFAULT_SOURCE_BEHAVIOR;
            }
            try {
                this.targetBehaviour = PowerStateSyncBehaviour.valueOf(configVariableProvider.getValue(TARGET_BEHAVIOUR_KEY));
            }
            catch (NotAvailableException ex) {
                this.targetBehaviour = DEFAULT_TARGET_BEHAVIOR;
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not apply config update for PowerStateSynchroniser[" + config.getLabel() + "]", (Throwable)ex);
        }
        if (active) {
            this.execute();
        }
        return unitConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetPowerStateRequest(PowerStateType.PowerState powerState) {
        Object object = this.AGENT_LOCK;
        synchronized (object) {
            try {
                if (powerState.getValue() == PowerStateType.PowerState.State.ON && this.latestPowerStateTarget == PowerStateType.PowerState.State.OFF && this.getPowerState(this.sourceRemote).getValue() != PowerStateType.PowerState.State.ON) {
                    this.setPowerState(this.sourceRemote, ON);
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle target power state request!", (Throwable)ex, (Logger)this.logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTargetPowerStateUpdate(PowerStateType.PowerState.State targetPowerState) {
        Object object = this.AGENT_LOCK;
        synchronized (object) {
            try {
                if (this.updateLatestTargetPowerState(targetPowerState)) {
                    switch (this.sourceBehaviour) {
                        case OFF: {
                            if (this.latestPowerStateSource == PowerStateType.PowerState.State.OFF) break;
                            this.setPowerState(this.sourceRemote, OFF);
                            break;
                        }
                        case ON: {
                            if (this.latestPowerStateSource == PowerStateType.PowerState.State.ON) break;
                            this.setPowerState(this.sourceRemote, ON);
                            break;
                        }
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle target power state update!", (Throwable)ex, (Logger)this.logger);
            }
        }
    }

    private boolean updateLatestTargetPowerState(PowerStateType.PowerState.State targetPowerState) throws CouldNotPerformException {
        if (this.latestPowerStateTarget == PowerStateType.PowerState.State.UNKNOWN) {
            this.latestPowerStateTarget = targetPowerState;
            return this.latestPowerStateTarget == PowerStateType.PowerState.State.OFF;
        }
        if (this.latestPowerStateTarget == PowerStateType.PowerState.State.OFF && targetPowerState == PowerStateType.PowerState.State.ON) {
            this.latestPowerStateTarget = PowerStateType.PowerState.State.ON;
            return false;
        }
        if (this.latestPowerStateTarget == PowerStateType.PowerState.State.ON && targetPowerState == PowerStateType.PowerState.State.OFF) {
            this.latestPowerStateTarget = PowerStateType.PowerState.State.OFF;
            for (UnitRemote targetRemote : this.targetRemotes) {
                if (this.getPowerState(targetRemote).getValue() != PowerStateType.PowerState.State.ON) continue;
                this.latestPowerStateTarget = PowerStateType.PowerState.State.ON;
                break;
            }
            return this.latestPowerStateTarget == PowerStateType.PowerState.State.OFF;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSourcePowerStateRequest(PowerStateType.PowerState powerState) {
        Object object = this.AGENT_LOCK;
        synchronized (object) {
            try {
                if (powerState.getValue() == PowerStateType.PowerState.State.OFF && this.latestPowerStateSource != PowerStateType.PowerState.State.OFF && this.latestPowerStateTarget != PowerStateType.PowerState.State.OFF) {
                    for (UnitRemote targetRemote : this.targetRemotes) {
                        this.setPowerState(targetRemote, OFF);
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((String)"Could not handle source power state request!", (Throwable)ex, (Logger)this.logger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSourcePowerStateUpdate(PowerStateType.PowerState.State sourcePowerState, Object target) {
        this.logger.debug("Handle new Value[" + sourcePowerState + "] for Source[" + target + "]");
        Object object = this.AGENT_LOCK;
        synchronized (object) {
            block11: {
                try {
                    this.latestPowerStateSource = sourcePowerState;
                    if (this.latestPowerStateSource != PowerStateType.PowerState.State.ON) break block11;
                    switch (this.targetBehaviour) {
                        case OFF: {
                            if (this.latestPowerStateTarget == PowerStateType.PowerState.State.OFF) break;
                            for (UnitRemote targetRemote : this.targetRemotes) {
                                this.setPowerState(targetRemote, OFF);
                            }
                            break;
                        }
                        case ON: {
                            if (this.latestPowerStateTarget == PowerStateType.PowerState.State.ON) break;
                            for (UnitRemote targetRemote : this.targetRemotes) {
                                this.setPowerState(targetRemote, ON);
                            }
                            break;
                        }
                    }
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((String)"Could not handle source power state change!", (Throwable)ex, (Logger)this.logger);
                }
            }
        }
    }

    private void setPowerState(UnitRemote remote, PowerStateType.PowerState powerState) throws CouldNotPerformException {
        Services.invokeOperationServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, (Object)remote, (Object[])new Object[]{powerState});
    }

    private PowerStateType.PowerState getPowerState(Object object) throws CouldNotPerformException {
        return (PowerStateType.PowerState)Services.invokeProviderServiceMethod((ServiceTemplateType.ServiceTemplate.ServiceType)ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, (Object)object, (Object[])new Object[0]);
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Executing PowerStateSynchroniser agent");
        this.sourceRemote.waitForData();
        String targetIds = "";
        this.latestPowerStateTarget = PowerStateType.PowerState.State.UNKNOWN;
        for (UnitRemote targetRemote : this.targetRemotes) {
            targetRemote.waitForData();
            targetIds = targetIds + "[" + targetRemote.getLabel() + "]";
            if ((this.latestPowerStateTarget == PowerStateType.PowerState.State.OFF || this.latestPowerStateTarget == PowerStateType.PowerState.State.UNKNOWN) && this.getPowerState(targetRemote.getData()).getValue() == PowerStateType.PowerState.State.ON) {
                this.latestPowerStateTarget = PowerStateType.PowerState.State.ON;
            } else if (this.latestPowerStateTarget == PowerStateType.PowerState.State.UNKNOWN && this.getPowerState(targetRemote.getData()).getValue() == PowerStateType.PowerState.State.OFF) {
                this.latestPowerStateTarget = PowerStateType.PowerState.State.OFF;
            }
            targetRemote.addServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.REQUESTED, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.targetRequestObserer);
            targetRemote.addServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.CURRENT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.targetObserver);
            this.handleTargetPowerStateUpdate(this.getPowerState(targetRemote.getData()).getValue());
        }
        this.sourceRemote.addServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.REQUESTED, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.sourceRequestObserver);
        this.sourceRemote.addServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.CURRENT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.sourceObserver);
        this.handleSourcePowerStateUpdate(this.getPowerState(this.sourceRemote.getData()).getValue(), this.sourceRemote);
        this.logger.debug("Source [" + this.sourceRemote.getLabel() + "] behaviour [" + (Object)((Object)this.sourceBehaviour) + "]");
        this.logger.debug("Targets [" + targetIds + "] behaviour [" + (Object)((Object)this.targetBehaviour) + "]");
    }

    protected void stop() {
        try {
            this.logger.debug("Stopping PowerStateSynchroniserAgent[" + this.getLabel() + "]");
        }
        catch (NotAvailableException ex) {
            this.logger.debug("Stopping PowerStateSynchroniserAgent");
        }
        if (this.sourceRemote != null) {
            this.sourceRemote.removeServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.REQUESTED, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.sourceRequestObserver);
            this.sourceRemote.removeServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.CURRENT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.sourceObserver);
        }
        this.targetRemotes.forEach(targetRemote -> {
            targetRemote.removeServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.REQUESTED, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.targetRequestObserer);
            targetRemote.removeServiceStateObserver(ServiceTempusTypeType.ServiceTempusType.ServiceTempus.CURRENT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, this.targetObserver);
        });
    }

    public UnitRemote getSourceRemote() {
        return this.sourceRemote;
    }

    public List<UnitRemote> getTargetRemotes() {
        return this.targetRemotes;
    }

    public PowerStateSyncBehaviour getSourceBehaviour() {
        return this.sourceBehaviour;
    }

    public PowerStateSyncBehaviour getTargetBehaviour() {
        return this.targetBehaviour;
    }

    public static enum PowerStateSyncBehaviour {
        ON,
        OFF,
        LAST_STATE;

    }
}

