/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import java.util.concurrent.ExecutionException;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.action.ActionRescheduler;
import org.openbase.bco.dal.remote.trigger.GenericBCOTrigger;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.preset.AbstractResourceAllocationAgent;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.openbase.jul.pattern.trigger.TriggerPool;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class PresenceLightAgent
extends AbstractResourceAllocationAgent {
    private LocationRemote locationRemote;
    private final PresenceStateType.PresenceState.State triggerState = PresenceStateType.PresenceState.State.PRESENT;

    public PresenceLightAgent() throws InstantiationException {
        super(PresenceLightAgent.class);
        this.actionRescheduleHelper = new ActionRescheduler(ActionRescheduler.RescheduleOption.EXTEND, 30L);
        this.triggerHolderObserver = (source, data) -> {
            this.logger.warn("New trigger state: " + data.getValue());
            GlobalCachedExecutorService.submit(() -> {
                if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                    this.switchlightsOn();
                } else {
                    this.logger.warn("Stop execution");
                    this.actionRescheduleHelper.stopExecution();
                }
                return null;
            });
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)true, (Class)Units.LOCATION);
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
        }
        try {
            GenericBCOTrigger agentTrigger = new GenericBCOTrigger((AbstractUnitRemote)this.locationRemote, (Enum)this.triggerState, ServiceTemplateType.ServiceTemplate.ServiceType.PRESENCE_STATE_SERVICE);
            this.agentTriggerHolder.addTrigger((AbstractTrigger)agentTrigger, TriggerPool.TriggerOperation.OR);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
        }
    }

    private void switchlightsOn() {
        try {
            ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)this.locationRemote, PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.ON).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
            this.actionRescheduleHelper.startActionRescheduleing(((ActionFutureType.ActionFuture)this.locationRemote.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
        }
        catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
            this.logger.error("Could not switch on Lights.", ex);
        }
    }
}

