/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core;

import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.bco.manager.agent.lib.Agent;
import org.openbase.bco.manager.agent.lib.AgentController;
import org.openbase.bco.manager.agent.lib.AgentFactory;
import org.openbase.bco.registry.agent.remote.CachedAgentRegistryRemote;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.scope.ScopeGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.agent.AgentClassType;
import rst.rsb.ScopeType;

public class AgentFactoryImpl
implements AgentFactory {
    protected final Logger logger = LoggerFactory.getLogger(AgentFactoryImpl.class);
    private static AgentFactoryImpl instance;

    public static synchronized AgentFactory getInstance() {
        if (instance == null) {
            instance = new AgentFactoryImpl();
        }
        return instance;
    }

    private AgentFactoryImpl() {
    }

    public AgentController newInstance(UnitConfigType.UnitConfig agentUnitConfig) throws InstantiationException {
        AgentController agent;
        try {
            if (agentUnitConfig == null) {
                throw new NotAvailableException("agentconfig");
            }
            if (!agentUnitConfig.getAgentConfig().hasAgentClassId()) {
                throw new NotAvailableException("agentype");
            }
            if (!agentUnitConfig.hasScope() && agentUnitConfig.getScope().getComponentList().isEmpty()) {
                throw new NotAvailableException("scope");
            }
            CachedAgentRegistryRemote.waitForData();
            Class<?> agentClass = Thread.currentThread().getContextClassLoader().loadClass(this.getAgentClass(agentUnitConfig));
            this.logger.debug("Creating agent of type [" + agentClass.getSimpleName() + "] on scope [" + ScopeGenerator.generateStringRep((ScopeType.Scope)agentUnitConfig.getScope()) + "]");
            agent = (AgentController)agentClass.newInstance();
            agent.init(agentUnitConfig);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | java.lang.InstantiationException | InterruptedException | SecurityException | CouldNotPerformException ex) {
            throw new InstantiationException(Agent.class, agentUnitConfig.getId(), ex);
        }
        return agent;
    }

    private String getAgentClass(UnitConfigType.UnitConfig agentUnitConfig) throws InterruptedException, NotAvailableException {
        try {
            Registries.getAgentRegistry().waitForData();
            AgentClassType.AgentClass agentClass = Registries.getAgentRegistry().getAgentClassById(agentUnitConfig.getAgentConfig().getAgentClassId());
            return AbstractAgentController.class.getPackage().getName() + ".preset." + agentClass.getLabel() + "Agent";
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("AgentClass", (Throwable)ex);
        }
    }
}

