/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import org.openbase.bco.dal.lib.jp.JPResourceAllocation;
import org.openbase.bco.dal.remote.action.ActionRescheduler;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.jps.core.JPService;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.pattern.Observer;
import rst.domotic.state.ActivationStateType;
import rst.domotic.unit.UnitConfigType;

public abstract class AbstractResourceAllocationAgent
extends AbstractAgentController {
    protected ActionRescheduler actionRescheduleHelper;
    protected Observer<ActivationStateType.ActivationState> triggerHolderObserver;

    public AbstractResourceAllocationAgent(Class unitClass) throws InstantiationException {
        super(unitClass);
    }

    protected void postInit() throws InitializationException, InterruptedException {
        super.postInit();
        this.agentTriggerHolder.registerObserver(this.triggerHolderObserver);
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        try {
            if (!((Boolean)((JPResourceAllocation)JPService.getProperty(JPResourceAllocation.class)).getValue()).booleanValue()) {
                this.logger.info("Skip activatio of agent [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "] because resource allocation is disabled");
                return;
            }
        }
        catch (JPNotAvailableException ex) {
            throw new CouldNotPerformException("Could not access JPResourceAllocation property", (Throwable)ex);
        }
        this.agentTriggerHolder.activate();
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Deactivating [" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.actionRescheduleHelper.stopExecution();
        this.agentTriggerHolder.deactivate();
    }

    public void shutdown() {
        this.actionRescheduleHelper.stopExecution();
        this.agentTriggerHolder.deregisterObserver(this.triggerHolderObserver);
        this.agentTriggerHolder.shutdown();
        super.shutdown();
    }
}

