/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import com.google.protobuf.Message;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.dal.lib.layer.unit.UnitRemote;
import org.openbase.bco.dal.remote.action.ActionRescheduler;
import org.openbase.bco.dal.remote.trigger.GenericBCOTrigger;
import org.openbase.bco.dal.remote.unit.AbstractUnitRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.preset.AbstractResourceAllocationAgent;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.trigger.AbstractTrigger;
import org.openbase.jul.pattern.trigger.TriggerPool;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import rst.communicationpatterns.ResourceAllocationType;
import rst.domotic.action.ActionAuthorityType;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.action.ActionFutureType;
import rst.domotic.action.MultiResourceAllocationStrategyType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.PresenceStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class RandomLightPatternAgent
extends AbstractResourceAllocationAgent {
    private LocationRemote locationRemote;
    private Thread thread;
    private final PresenceStateType.PresenceState.State triggerState = PresenceStateType.PresenceState.State.ABSENT;

    public RandomLightPatternAgent() throws InstantiationException {
        super(RandomLightPatternAgent.class);
        this.actionRescheduleHelper = new ActionRescheduler(ActionRescheduler.RescheduleOption.EXTEND, 30L);
        this.triggerHolderObserver = (source, data) -> GlobalCachedExecutorService.submit(() -> {
            if (data.getValue().equals((Object)ActivationStateType.ActivationState.State.ACTIVE)) {
                this.makeRandomLightPattern();
            } else {
                this.stopRandomLightPattern();
            }
            return null;
        });
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        super.init(config);
        try {
            this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)false, (Class)Units.LOCATION);
        }
        catch (NotAvailableException ex) {
            throw new InitializationException((Object)"LocationRemote not available.", (Throwable)ex);
        }
        try {
            GenericBCOTrigger agentTrigger = new GenericBCOTrigger((AbstractUnitRemote)this.locationRemote, (Enum)this.triggerState, ServiceTemplateType.ServiceTemplate.ServiceType.PRESENCE_STATE_SERVICE);
            this.agentTriggerHolder.addTrigger((AbstractTrigger)agentTrigger, TriggerPool.TriggerOperation.OR);
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"Could not add agent to agentpool", (Throwable)ex);
        }
    }

    @Override
    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.stopRandomLightPattern();
        super.stop();
    }

    private void makeRandomLightPattern() {
        this.thread = new PersonSimulator();
        this.thread.start();
    }

    private void stopRandomLightPattern() {
        this.thread.interrupt();
    }

    private class PersonSimulator
    extends Thread {
        private PersonSimulator() {
        }

        @Override
        public void run() {
            try {
                List childLocationList = RandomLightPatternAgent.this.locationRemote.getChildLocationList(true);
                LocationRemote currentLocation = (LocationRemote)childLocationList.get(ThreadLocalRandom.current().nextInt(childLocationList.size()));
                while (true) {
                    ActionDescriptionType.ActionDescription.Builder actionDescriptionBuilder = RandomLightPatternAgent.this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)currentLocation, (Message)PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.ON).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
                    RandomLightPatternAgent.this.actionRescheduleHelper.startActionRescheduleing(((ActionFutureType.ActionFuture)currentLocation.applyAction(actionDescriptionBuilder.build()).get()).toBuilder());
                    Thread.sleep(600000L);
                    RandomLightPatternAgent.this.actionRescheduleHelper.stopExecution();
                    actionDescriptionBuilder = RandomLightPatternAgent.this.getNewActionDescription(ActionAuthorityType.ActionAuthority.getDefaultInstance(), ResourceAllocationType.ResourceAllocation.Initiator.SYSTEM, 30000L, ResourceAllocationType.ResourceAllocation.Policy.FIRST, ResourceAllocationType.ResourceAllocation.Priority.NORMAL, (UnitRemote)currentLocation, (Message)PowerStateType.PowerState.newBuilder().setValue(PowerStateType.PowerState.State.OFF).build(), UnitTemplateType.UnitTemplate.UnitType.LIGHT, ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, MultiResourceAllocationStrategyType.MultiResourceAllocationStrategy.Strategy.AT_LEAST_ONE);
                    ((ActionFutureType.ActionFuture)currentLocation.applyAction(actionDescriptionBuilder.build()).get()).toBuilder();
                    List neighborLocationList = currentLocation.getNeighborLocationList(true);
                    currentLocation = (LocationRemote)neighborLocationList.get(ThreadLocalRandom.current().nextInt(neighborLocationList.size()));
                }
            }
            catch (InterruptedException | ExecutionException | CouldNotPerformException ex) {
                Logger.getLogger(RandomLightPatternAgent.class.getName()).log(Level.SEVERE, null, ex);
                this.interrupt();
                return;
            }
        }

        @Override
        public void interrupt() {
            RandomLightPatternAgent.this.actionRescheduleHelper.stopExecution();
            super.interrupt();
        }
    }
}

