/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.agent.core.preset;

import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.dal.remote.unit.location.LocationRemote;
import org.openbase.bco.manager.agent.core.AbstractAgentController;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.openbase.jul.schedule.Timeout;
import org.slf4j.Logger;
import rst.domotic.state.PresenceStateType;
import rst.domotic.state.StandbyStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.location.LocationDataType;

public class StandbyAgent
extends AbstractAgentController {
    public static final long TIMEOUT = 900000L;
    private LocationRemote locationRemote;
    private final Timeout timeout;
    private final SyncObject standbySync = new SyncObject("StandbySync");
    private final Observer<LocationDataType.LocationData> locationDataObserver;

    public StandbyAgent() throws CouldNotPerformException {
        super(StandbyAgent.class);
        this.timeout = new Timeout(900000L){

            public void expired() {
                try {
                    StandbyAgent.this.locationRemote.setStandbyState(StandbyStateType.StandbyState.State.STANDBY);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)ex, (Logger)StandbyAgent.this.logger);
                }
            }
        };
        this.locationDataObserver = (source, data) -> this.triggerPresenceChange((LocationDataType.LocationData)data);
    }

    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.locationRemote = (LocationRemote)Units.getUnit((String)((UnitConfigType.UnitConfig)this.getConfig()).getPlacementConfig().getLocationId(), (boolean)false, (Class)Units.LOCATION);
        this.locationRemote.addDataObserver(this.locationDataObserver);
        if (this.locationRemote.isDataAvailable()) {
            this.triggerPresenceChange((LocationDataType.LocationData)this.locationRemote.getData());
        }
    }

    protected void stop() {
        if (this.locationRemote != null) {
            this.locationRemote.removeDataObserver(this.locationDataObserver);
            this.locationRemote = null;
        }
        this.timeout.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerPresenceChange(LocationDataType.LocationData data) throws InterruptedException {
        SyncObject syncObject = this.standbySync;
        synchronized (syncObject) {
            if (data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.PRESENT) && this.timeout.isActive()) {
                this.timeout.cancel();
                try {
                    this.locationRemote.setStandbyState(StandbyStateType.StandbyState.State.RUNNING);
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not notify motion state change!", (Throwable)ex), (Logger)this.logger);
                }
            } else if (data.getPresenceState().getValue().equals((Object)PresenceStateType.PresenceState.State.ABSENT) && !this.timeout.isActive()) {
                try {
                    this.timeout.start();
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not schedule presence timeout!", (Throwable)ex), (Logger)this.logger);
                }
            }
        }
    }
}

