/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.location.lib.util;

import com.google.protobuf.GeneratedMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.dal.lib.transform.HSBColorToRGBColorTransformer;
import org.openbase.bco.dal.remote.unit.ColorableLightRemote;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.vision.HSBColorType;

public class ColorControl {
    public static final Random random = new Random();
    private final LocationRegistryRemote locationRegistryRemote;
    private final List<ColorableLightRemote> ambientLightRemoteList;

    public ColorControl(String locationId) throws InstantiationException, InterruptedException {
        try {
            this.locationRegistryRemote = new LocationRegistryRemote();
            this.locationRegistryRemote.init();
            this.locationRegistryRemote.activate();
            List unitConfigs = this.locationRegistryRemote.getUnitConfigsByLocation(UnitTemplateType.UnitTemplate.UnitType.COLORABLE_LIGHT, locationId);
            this.ambientLightRemoteList = new ArrayList<ColorableLightRemote>();
            for (UnitConfigType.UnitConfig unitConfig : unitConfigs) {
                ColorableLightRemote ambientLightRemote = new ColorableLightRemote();
                ambientLightRemote.init((GeneratedMessage)unitConfig);
                this.ambientLightRemoteList.add(ambientLightRemote);
                ambientLightRemote.activate();
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public Future<HSBColorType.HSBColor> execute(Color color) throws InterruptedException, CouldNotPerformException {
        return this.execute(HSBColorToRGBColorTransformer.transform((Color)color));
    }

    public Future<HSBColorType.HSBColor> execute(final HSBColorType.HSBColor color) throws InterruptedException, CouldNotPerformException {
        return GlobalCachedExecutorService.submit((Callable)new Callable<HSBColorType.HSBColor>(){

            @Override
            public HSBColorType.HSBColor call() throws Exception {
                for (ColorableLightRemote remote : ColorControl.this.ambientLightRemoteList) {
                    try {
                        remote.setColor(color);
                    }
                    catch (CouldNotPerformException ex) {
                        Logger.getLogger(ColorControl.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                return color;
            }
        });
    }
}

