/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.location.lib.util;

import com.google.protobuf.GeneratedMessage;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.dal.remote.unit.ColorableLightRemote;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import rst.domotic.state.PowerStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class PowerControl {
    public static final Random random = new Random();
    private final LocationRegistryRemote locationRegistryRemote;
    private final List<ColorableLightRemote> ambientLightRemoteList;
    private final PowerStateType.PowerState.State powerState;

    public PowerControl(String locationId, PowerStateType.PowerState.State powerState) throws InstantiationException, InterruptedException {
        try {
            this.powerState = powerState;
            this.locationRegistryRemote = new LocationRegistryRemote();
            this.locationRegistryRemote.init();
            this.locationRegistryRemote.activate();
            List unitConfigs = this.locationRegistryRemote.getUnitConfigsByLocation(UnitTemplateType.UnitTemplate.UnitType.COLORABLE_LIGHT, locationId);
            this.ambientLightRemoteList = new ArrayList<ColorableLightRemote>();
            for (UnitConfigType.UnitConfig unitConfig : unitConfigs) {
                ColorableLightRemote ambientLightRemote = new ColorableLightRemote();
                ambientLightRemote.init((GeneratedMessage)unitConfig);
                this.ambientLightRemoteList.add(ambientLightRemote);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        for (ColorableLightRemote remote : this.ambientLightRemoteList) {
            remote.activate();
        }
        new Thread(){

            @Override
            public void run() {
                for (ColorableLightRemote remote : PowerControl.this.ambientLightRemoteList) {
                    try {
                        remote.setColor(Color.BLACK);
                        remote.callMethodAsync("setPower", (Object)PowerStateType.PowerState.newBuilder().setValue(PowerControl.this.powerState).build());
                    }
                    catch (CouldNotPerformException ex) {
                        Logger.getLogger(PowerControl.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }.start();
    }
}

