/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.location.lib.util;

import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import org.openbase.bco.dal.remote.service.PowerStateServiceRemote;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.PowerStateType;

public class PowerServiceControl {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final Random random = new Random();
    private final PowerStateServiceRemote powerServiceRemote;
    private final LocationRegistryRemote locationRegistryRemote;
    private final PowerStateType.PowerState powerState;

    public PowerServiceControl(String locationId, PowerStateType.PowerState.State powerState) throws InstantiationException, InterruptedException {
        try {
            this.powerState = PowerStateType.PowerState.newBuilder().setValue(powerState).build();
            this.locationRegistryRemote = new LocationRegistryRemote();
            this.locationRegistryRemote.init();
            this.locationRegistryRemote.activate();
            List unitConfigs = this.locationRegistryRemote.getUnitConfigsByLocation(ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE, locationId);
            this.powerServiceRemote = new PowerStateServiceRemote();
            try {
                this.powerServiceRemote.init((Collection)unitConfigs);
            }
            catch (Exception ex) {
                ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        new Thread(){

            @Override
            public void run() {
                try {
                    PowerServiceControl.this.powerServiceRemote.setPowerState(PowerServiceControl.this.powerState);
                }
                catch (CouldNotPerformException ex) {
                    java.util.logging.Logger.getLogger(PowerServiceControl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }.start();
    }
}

