/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.location.lib.util;

import com.google.protobuf.GeneratedMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openbase.bco.dal.remote.unit.ColorableLightRemote;
import org.openbase.bco.registry.location.remote.LocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.vision.HSBColorType;

@Deprecated
public class ColorLoopControl {
    public static final Random random = new Random();
    private final LocationRegistryRemote locationRegistryRemote;
    private final ArrayList<HSBColorType.HSBColor> colorList;
    private final List<ColorableLightRemote> ambientLightRemoteList;
    private final long delay;

    public ColorLoopControl(String locationId, Collection<HSBColorType.HSBColor> colors) throws InstantiationException, InterruptedException {
        this(locationId, colors, 500L);
    }

    public ColorLoopControl(String locationId, Collection<HSBColorType.HSBColor> colors, long delay) throws InstantiationException, InterruptedException {
        try {
            this.delay = delay;
            this.colorList = new ArrayList<HSBColorType.HSBColor>(colors);
            this.locationRegistryRemote = new LocationRegistryRemote();
            this.locationRegistryRemote.init();
            this.locationRegistryRemote.activate();
            List unitConfigs = this.locationRegistryRemote.getUnitConfigsByLocation(UnitTemplateType.UnitTemplate.UnitType.COLORABLE_LIGHT, locationId);
            this.ambientLightRemoteList = new ArrayList<ColorableLightRemote>();
            for (UnitConfigType.UnitConfig unitConfig : unitConfigs) {
                ColorableLightRemote ambientLightRemote = new ColorableLightRemote();
                ambientLightRemote.init((GeneratedMessage)unitConfig);
                this.ambientLightRemoteList.add(ambientLightRemote);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        for (ColorableLightRemote remote : this.ambientLightRemoteList) {
            remote.activate();
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    while (!this.isInterrupted()) {
                        Collections.shuffle(ColorLoopControl.this.ambientLightRemoteList);
                        for (ColorableLightRemote remote : ColorLoopControl.this.ambientLightRemoteList) {
                            try {
                                remote.setColor(ColorLoopControl.this.getRandomColor());
                                if (ColorLoopControl.this.delay > 0L) {
                                    Thread.sleep(ColorLoopControl.this.delay);
                                    continue;
                                }
                                Thread.yield();
                            }
                            catch (CouldNotPerformException ex) {
                                Logger.getLogger(ColorLoopControl.class.getName()).log(Level.SEVERE, null, ex);
                            }
                        }
                    }
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ColorLoopControl.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }.start();
    }

    public HSBColorType.HSBColor getRandomColor() {
        return this.colorList.get(random.nextInt(this.colorList.size()));
    }
}

