/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.location.remote;

import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.openbase.bco.manager.location.lib.Location;
import org.openbase.bco.registry.location.remote.CachedLocationRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.extension.rsb.com.AbstractConfigurableRemote;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.pattern.Remote;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionConfigType;
import rst.domotic.action.SnapshotType;
import rst.domotic.state.AlarmStateType;
import rst.domotic.state.BlindStateType;
import rst.domotic.state.BrightnessStateType;
import rst.domotic.state.ColorStateType;
import rst.domotic.state.MotionStateType;
import rst.domotic.state.PowerConsumptionStateType;
import rst.domotic.state.PowerStateType;
import rst.domotic.state.SmokeStateType;
import rst.domotic.state.StandbyStateType;
import rst.domotic.state.TamperStateType;
import rst.domotic.state.TemperatureStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.location.LocationDataType;
import rst.vision.ColorType;
import rst.vision.HSBColorType;
import rst.vision.RGBColorType;

public class LocationRemote
extends AbstractConfigurableRemote<LocationDataType.LocationData, UnitConfigType.UnitConfig>
implements Location {
    public LocationRemote() {
        super(LocationDataType.LocationData.class, UnitConfigType.UnitConfig.class);
    }

    public void notifyDataUpdate(LocationDataType.LocationData data) throws CouldNotPerformException {
    }

    public String getLabel() throws NotAvailableException {
        try {
            return ((UnitConfigType.UnitConfig)this.getConfig()).getLabel();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("label", (Throwable)ex);
        }
    }

    public void activate() throws InterruptedException, CouldNotPerformException {
        CachedLocationRegistryRemote.waitForData();
        super.activate();
    }

    public Future<Void> setBrightnessState(BrightnessStateType.BrightnessState brightness) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)brightness, (Remote)this, Void.class);
    }

    public BrightnessStateType.BrightnessState getBrightnessState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getBrightnessState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Brightness", (Throwable)ex);
        }
    }

    public Future<Void> setColorState(ColorStateType.ColorState color) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)color, (Remote)this, Void.class);
    }

    public ColorStateType.ColorState getColorState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getColorState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Color", (Throwable)ex);
        }
    }

    public void setPowerState(PowerStateType.PowerState.State state) throws CouldNotPerformException {
        this.setPowerState(PowerStateType.PowerState.newBuilder().setValue(state).build());
    }

    public Future<Void> setPowerState(PowerStateType.PowerState state) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)state, (Remote)this, Void.class);
    }

    public PowerStateType.PowerState getPowerState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getPowerState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerState", (Throwable)ex);
        }
    }

    public Future<Void> setBlindState(BlindStateType.BlindState state) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)state, (Remote)this, Void.class);
    }

    public BlindStateType.BlindState getBlindState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getBlindState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("ShutterState", (Throwable)ex);
        }
    }

    public Future<Void> setStandbyState(StandbyStateType.StandbyState state) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)state, (Remote)this, Void.class);
    }

    public StandbyStateType.StandbyState getStandbyState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getStandbyState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("StandbyState", (Throwable)ex);
        }
    }

    public Future<Void> setTargetTemperatureState(TemperatureStateType.TemperatureState value) throws CouldNotPerformException {
        return RPCHelper.callRemoteMethod((Object)value, (Remote)this, Void.class);
    }

    public TemperatureStateType.TemperatureState getTargetTemperatureState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getTargetTemperatureState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("TargetTemperature", (Throwable)ex);
        }
    }

    public MotionStateType.MotionState getMotionState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getMotionState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("MotionState", (Throwable)ex);
        }
    }

    public AlarmStateType.AlarmState getSmokeAlarmState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getSmokeAlarmState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("AlarmState", (Throwable)ex);
        }
    }

    public SmokeStateType.SmokeState getSmokeState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getSmokeState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("SmokeState", (Throwable)ex);
        }
    }

    public TemperatureStateType.TemperatureState getTemperatureState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getAcutalTemperatureState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("Temperature", (Throwable)ex);
        }
    }

    public PowerConsumptionStateType.PowerConsumptionState getPowerConsumptionState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getPowerConsumptionState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("PowerConsumptionState", (Throwable)ex);
        }
    }

    public TamperStateType.TamperState getTamperState() throws NotAvailableException {
        try {
            return ((LocationDataType.LocationData)this.getData()).getTamperState();
        }
        catch (CouldNotPerformException ex) {
            throw new NotAvailableException("TamperState", (Throwable)ex);
        }
    }

    public Future<SnapshotType.Snapshot> recordSnapshot() throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Remote)this, SnapshotType.Snapshot.class);
    }

    public Future<Void> restoreSnapshot(SnapshotType.Snapshot snapshot) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)snapshot, (Remote)this, Void.class);
    }

    public Future<Void> applyAction(ActionConfigType.ActionConfig actionConfig) throws CouldNotPerformException, InterruptedException {
        return RPCHelper.callRemoteMethod((Object)actionConfig, (Remote)this, Void.class);
    }

    public List<String> getNeighborLocationIds() throws CouldNotPerformException {
        ArrayList<String> neighborIdList = new ArrayList<String>();
        try {
            for (UnitConfigType.UnitConfig locationConfig : CachedLocationRegistryRemote.getRegistry().getNeighborLocations(this.getId())) {
                neighborIdList.add(locationConfig.getId());
            }
        }
        catch (InterruptedException ex) {
            throw new CouldNotPerformException("Could not get CachedLocationRegistryRemote!", (Throwable)ex);
        }
        return neighborIdList;
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)LocationDataType.LocationData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)AlarmStateType.AlarmState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)MotionStateType.MotionState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerConsumptionStateType.PowerConsumptionState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)PowerStateType.PowerState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BlindStateType.BlindState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SmokeStateType.SmokeState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)StandbyStateType.StandbyState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TamperStateType.TamperState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)HSBColorType.HSBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorStateType.ColorState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ColorType.Color.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)RGBColorType.RGBColor.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)BrightnessStateType.BrightnessState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)TemperatureStateType.TemperatureState.getDefaultInstance()));
    }
}

