/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import org.openbase.bco.manager.scene.core.SceneManagerController;
import org.openbase.bco.manager.scene.lib.SceneManager;
import org.openbase.jps.core.JPService;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneManagerLauncher {
    protected static final Logger logger = LoggerFactory.getLogger(SceneManagerLauncher.class);
    private final SceneManagerController sceneManagerController;

    public SceneManagerLauncher() throws InstantiationException, InterruptedException {
        try {
            this.sceneManagerController = new SceneManagerController();
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void launch() throws InstantiationException, InterruptedException {
        try {
            this.sceneManagerController.init();
        }
        catch (CouldNotPerformException ex) {
            this.sceneManagerController.shutdown();
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void shutdown() {
        this.sceneManagerController.shutdown();
    }

    public static void main(String[] args) throws InterruptedException, CouldNotPerformException {
        JPService.setApplicationName(SceneManager.class);
        JPService.parseAndExitOnError((String[])args);
        logger.info("Start " + JPService.getApplicationName() + "...");
        try {
            new SceneManagerLauncher().launch();
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistoryAndExit((String)(JPService.getApplicationName() + " crashed during startup phase!"), (Throwable)ex, (Logger)logger);
            return;
        }
        logger.info(JPService.getApplicationName() + " successfully started.");
    }
}

