/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openbase.bco.dal.remote.control.action.Action;
import org.openbase.bco.dal.remote.unit.ButtonRemote;
import org.openbase.bco.manager.scene.lib.Scene;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.registry.device.lib.DeviceRegistry;
import org.openbase.bco.registry.device.remote.CachedDeviceRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rsb.com.AbstractExecutableController;
import org.openbase.jul.extension.rsb.com.RPCHelper;
import org.openbase.jul.extension.rsb.iface.RSBLocalServer;
import org.openbase.jul.pattern.Observable;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionConfigType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.ButtonStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.dal.ButtonDataType;
import rst.domotic.unit.scene.SceneDataType;

public class SceneControllerImpl
extends AbstractExecutableController<SceneDataType.SceneData, SceneDataType.SceneData.Builder, UnitConfigType.UnitConfig>
implements SceneController {
    private final List<ButtonRemote> buttonRemoteList;
    private final List<Action> actionList;
    private final SyncObject triggerListSync = new SyncObject("TriggerListSync");
    private final SyncObject actionListSync = new SyncObject("ActionListSync");
    private final Observer<ButtonDataType.ButtonData> buttonObserver;
    private DeviceRegistry deviceRegistry;

    public SceneControllerImpl() throws InstantiationException {
        super((GeneratedMessage.Builder)SceneDataType.SceneData.newBuilder(), false);
        this.buttonRemoteList = new ArrayList<ButtonRemote>();
        this.actionList = new ArrayList<Action>();
        this.buttonObserver = new Observer<ButtonDataType.ButtonData>(){

            public void update(Observable<ButtonDataType.ButtonData> source, ButtonDataType.ButtonData data) throws Exception {
                if (data.getButtonState().getValue().equals((Object)ButtonStateType.ButtonState.State.PRESSED)) {
                    SceneControllerImpl.this.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build());
                }
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            CachedDeviceRegistryRemote.waitForData();
            this.deviceRegistry = CachedDeviceRegistryRemote.getRegistry();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
        super.init((GeneratedMessage)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        SyncObject syncObject = this.triggerListSync;
        synchronized (syncObject) {
            block20: {
                try {
                    for (ButtonRemote buttonRemote : this.buttonRemoteList) {
                        buttonRemote.deactivate();
                        buttonRemote.removeDataObserver(this.buttonObserver);
                    }
                    this.buttonRemoteList.clear();
                    for (UnitConfigType.UnitConfig unitConfig : this.deviceRegistry.getUnitConfigsByLabel(config.getLabel())) {
                        if (unitConfig.getType() != UnitTemplateType.UnitTemplate.UnitType.BUTTON) continue;
                        try {
                            ButtonRemote buttonRemote = new ButtonRemote();
                            buttonRemote.init((GeneratedMessage)unitConfig);
                            this.buttonRemoteList.add(buttonRemote);
                        }
                        catch (InitializationException ex) {
                            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not register remote for Button[" + unitConfig.getLabel() + "]!", (Throwable)ex), (Logger)this.logger);
                        }
                    }
                    if (!this.isEnabled()) break block20;
                    for (ButtonRemote button : this.buttonRemoteList) {
                        button.activate();
                        try {
                            button.waitForData(2L, TimeUnit.SECONDS);
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Initial button sync failed!", (Throwable)ex), (Logger)this.logger);
                        }
                        button.addDataObserver(this.buttonObserver);
                    }
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not init all related button remotes.", (Throwable)ex), (Logger)this.logger);
                }
            }
        }
        MultiException.ExceptionStack exceptionStack = null;
        SyncObject ex = this.actionListSync;
        synchronized (ex) {
            this.actionList.clear();
            for (ActionConfigType.ActionConfig actionConfig : config.getSceneConfig().getActionConfigList()) {
                Action action = new Action();
                try {
                    action.init(actionConfig);
                    this.actionList.add(action);
                }
                catch (CouldNotPerformException ex2) {
                    exceptionStack = MultiException.push((Object)((Object)this), (Exception)((Object)ex2), exceptionStack);
                }
            }
        }
        try {
            MultiException.checkAndThrow((String)"Could not activate service remotes for some actions", exceptionStack);
        }
        catch (CouldNotPerformException ex2) {
            ExceptionPrinter.printHistory((Throwable)ex2, (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        return (UnitConfigType.UnitConfig)super.applyConfigUpdate((GeneratedMessage)config);
    }

    public void enable() throws CouldNotPerformException, InterruptedException {
        this.logger.info("enable " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
        super.enable();
        for (ButtonRemote button : this.buttonRemoteList) {
            button.activate();
            button.addDataObserver(this.buttonObserver);
        }
    }

    public void disable() throws CouldNotPerformException, InterruptedException {
        this.logger.info("disable " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
        for (ButtonRemote button : this.buttonRemoteList) {
            button.removeDataObserver(this.buttonObserver);
            button.deactivate();
        }
        super.disable();
    }

    public void registerMethods(RSBLocalServer server) throws CouldNotPerformException {
        RPCHelper.registerInterface(Scene.class, (Object)((Object)this), (RSBLocalServer)server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activate scene: " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
        SyncObject syncObject = this.actionListSync;
        synchronized (syncObject) {
            for (Action action : this.actionList) {
                action.execute();
            }
        }
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    SceneControllerImpl.this.logger.info("Waiting for action finalisation...");
                    SyncObject syncObject = SceneControllerImpl.this.actionListSync;
                    synchronized (syncObject) {
                        for (Action action : SceneControllerImpl.this.actionList) {
                            try {
                                SceneControllerImpl.this.logger.info("Waiting for action [" + action.getConfig().getServiceAttributeType() + "]");
                                action.waitForFinalization();
                            }
                            catch (InterruptedException ex) {
                                ExceptionPrinter.printHistory((Throwable)ex, (Logger)SceneControllerImpl.this.logger);
                                break;
                            }
                        }
                    }
                    SceneControllerImpl.this.logger.info("All Actions are finished. Deactivate scene...");
                    SceneControllerImpl.this.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build());
                }
                catch (CouldNotPerformException ex) {
                    ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not wait for actions!", (Throwable)ex), (Logger)SceneControllerImpl.this.logger);
                }
            }
        };
        thread.start();
        this.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).build());
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Finished scene: " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SceneDataType.SceneData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActivationStateType.ActivationState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionConfigType.ActionConfig.getDefaultInstance()));
    }
}

