/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import org.openbase.bco.manager.scene.core.SceneFactoryImpl;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.manager.scene.lib.SceneFactory;
import org.openbase.bco.manager.scene.lib.SceneManager;
import org.openbase.bco.registry.scene.lib.SceneRegistry;
import org.openbase.bco.registry.scene.lib.provider.SceneRegistryProvider;
import org.openbase.bco.registry.scene.remote.SceneRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.ControllerRegistry;
import org.openbase.jul.storage.registry.EnableableEntryRegistrySynchronizer;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;

public class SceneManagerController
implements SceneRegistryProvider,
SceneManager {
    protected static final Logger logger = LoggerFactory.getLogger(SceneManagerController.class);
    private static SceneManagerController instance;
    private final SceneFactory factory;
    private final ControllerRegistry<String, SceneController> sceneRegistry;
    private final SceneRegistryRemote sceneRegistryRemote;
    private final EnableableEntryRegistrySynchronizer<String, SceneController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> registrySynchronizer;

    public SceneManagerController() throws InstantiationException, InterruptedException {
        try {
            instance = this;
            this.factory = SceneFactoryImpl.getInstance();
            this.sceneRegistry = new ControllerRegistry();
            this.sceneRegistryRemote = new SceneRegistryRemote();
            this.registrySynchronizer = new EnableableEntryRegistrySynchronizer<String, SceneController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>(this.sceneRegistry, (RemoteRegistry)this.sceneRegistryRemote.getSceneConfigRemoteRegistry(), (Factory)this.factory){

                public boolean enablingCondition(UnitConfigType.UnitConfig config) {
                    return config.getEnablingState().getValue().equals((Object)EnablingStateType.EnablingState.State.ENABLED);
                }
            };
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public static SceneManagerController getInstance() throws NotAvailableException {
        if (instance == null) {
            throw new NotAvailableException(SceneManagerController.class);
        }
        return instance;
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            this.sceneRegistryRemote.init();
            this.sceneRegistryRemote.activate();
            this.sceneRegistryRemote.waitForData();
            this.registrySynchronizer.init();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void shutdown() {
        this.sceneRegistryRemote.shutdown();
        this.registrySynchronizer.shutdown();
        instance = null;
    }

    public SceneRegistry getSceneRegistry() throws NotAvailableException {
        return this.sceneRegistryRemote;
    }

    public RegistryImpl<String, SceneController> getSceneControllerRegistry() {
        return this.sceneRegistry;
    }
}

