/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import org.openbase.bco.manager.scene.core.SceneControllerImpl;
import org.openbase.bco.manager.scene.lib.Scene;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.manager.scene.lib.SceneFactory;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.unit.UnitConfigType;

public class SceneFactoryImpl
implements SceneFactory {
    protected final Logger logger = LoggerFactory.getLogger(SceneFactoryImpl.class);
    private static SceneFactoryImpl instance;

    public static synchronized SceneFactoryImpl getInstance() {
        if (instance == null) {
            instance = new SceneFactoryImpl();
        }
        return instance;
    }

    private SceneFactoryImpl() {
    }

    public SceneController newInstance(UnitConfigType.UnitConfig config) throws InstantiationException {
        SceneControllerImpl scene;
        try {
            if (config == null) {
                throw new NotAvailableException("UnitConfig");
            }
            this.logger.info("Creating scene [" + config.getId() + "]");
            scene = new SceneControllerImpl();
            scene.init(config);
        }
        catch (IllegalArgumentException | InterruptedException | SecurityException | CouldNotPerformException ex) {
            throw new InstantiationException(Scene.class, config.getId(), ex);
        }
        return scene;
    }
}

