/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.lib.layer.service.ServiceJSonProcessor;
import org.openbase.bco.dal.lib.layer.unit.AbstractExecutableBaseUnitController;
import org.openbase.bco.dal.remote.control.action.Action;
import org.openbase.bco.dal.remote.unit.ButtonRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.protobuf.ClosableDataBuilder;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.ButtonStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.dal.ButtonDataType;
import rst.domotic.unit.scene.SceneDataType;

public class SceneControllerImpl
extends AbstractExecutableBaseUnitController<SceneDataType.SceneData, SceneDataType.SceneData.Builder>
implements SceneController {
    private final Object buttonObserverLock = new SyncObject("ButtonObserverLock");
    private final Set<ButtonRemote> buttonRemoteSet;
    private final List<Action> actionList;
    private final SyncObject triggerListSync = new SyncObject("TriggerListSync");
    private final SyncObject actionListSync = new SyncObject("ActionListSync");
    private final Observer<ButtonDataType.ButtonData> buttonObserver;

    public SceneControllerImpl() throws InstantiationException {
        super(SceneControllerImpl.class, (GeneratedMessage.Builder)SceneDataType.SceneData.newBuilder());
        this.buttonRemoteSet = new HashSet<ButtonRemote>();
        this.actionList = new ArrayList<Action>();
        this.buttonObserver = (source, data) -> {
            if (data.getButtonState().getValue().equals((Object)ButtonStateType.ButtonState.State.PRESSED)) {
                this.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build());
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            Registries.getUnitRegistry().waitForData();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        config = super.applyConfigUpdate(config);
        SyncObject syncObject = this.triggerListSync;
        synchronized (syncObject) {
            try {
                Object object = this.buttonObserverLock;
                synchronized (object) {
                    for (ButtonRemote button : this.buttonRemoteSet) {
                        try {
                            this.logger.info("update: remove " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + " for button  " + button.getLabel());
                        }
                        catch (NotAvailableException ex) {
                            java.util.logging.Logger.getLogger(SceneControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        button.removeDataObserver(this.buttonObserver);
                    }
                    this.buttonRemoteSet.clear();
                    for (UnitConfigType.UnitConfig unitConfig : Registries.getUnitRegistry().getUnitConfigsByLabelAndUnitType(config.getLabel(), UnitTemplateType.UnitTemplate.UnitType.BUTTON)) {
                        try {
                            ButtonRemote buttonRemote = (ButtonRemote)Units.getUnit((UnitConfigType.UnitConfig)unitConfig, (boolean)false, (Class)Units.BUTTON);
                            this.buttonRemoteSet.add(buttonRemote);
                        }
                        catch (CouldNotPerformException ex) {
                            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not register remote for Button[" + unitConfig.getLabel() + "]!", (Throwable)ex), (Logger)this.logger);
                        }
                    }
                    if (this.isActive()) {
                        for (ButtonRemote button : this.buttonRemoteSet) {
                            try {
                                this.logger.info("update: register " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + " for button  " + button.getLabel());
                            }
                            catch (NotAvailableException ex) {
                                java.util.logging.Logger.getLogger(SceneControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                            }
                            button.addDataObserver(this.buttonObserver);
                        }
                    }
                }
            }
            catch (CouldNotPerformException ex) {
                ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not init all related button remotes.", (Throwable)ex), (Logger)this.logger);
            }
        }
        MultiException.ExceptionStack exceptionStack = null;
        SyncObject ex = this.actionListSync;
        synchronized (ex) {
            this.actionList.clear();
            for (ActionConfigType.ActionConfig actionConfig : config.getSceneConfig().getActionConfigList()) {
                Action action = new Action();
                try {
                    action.init(actionConfig);
                    this.actionList.add(action);
                }
                catch (CouldNotPerformException ex2) {
                    exceptionStack = MultiException.push((Object)((Object)this), (Exception)((Object)ex2), exceptionStack);
                }
            }
        }
        try {
            MultiException.checkAndThrow((String)("Could not fully init units of " + (Object)((Object)this)), exceptionStack);
        }
        catch (CouldNotPerformException ex2) {
            ExceptionPrinter.printHistory((Throwable)ex2, (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws InterruptedException, CouldNotPerformException {
        super.activate();
        Object object = this.buttonObserverLock;
        synchronized (object) {
            this.buttonRemoteSet.stream().forEach(button -> button.addDataObserver(this.buttonObserver));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws InterruptedException, CouldNotPerformException {
        this.logger.debug("deactivate " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
        Object object = this.buttonObserverLock;
        synchronized (object) {
            this.buttonRemoteSet.stream().forEach(button -> button.removeDataObserver(this.buttonObserver));
        }
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activate Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        HashMap<Future, Action> executionFutureList = new HashMap<Future, Action>();
        SyncObject syncObject = this.actionListSync;
        synchronized (syncObject) {
            for (Action action : this.actionList) {
                executionFutureList.put(action.execute(), action);
            }
        }
        MultiException.ExceptionStack exceptionStack = null;
        try {
            this.logger.debug("Waiting for action finalisation...");
            for (Map.Entry entry : executionFutureList.entrySet()) {
                this.logger.info("Waiting for action [" + ((Action)entry.getValue()).getConfig().getServiceAttributeType() + "]");
                try {
                    ((Future)entry.getKey()).get();
                }
                catch (ExecutionException ex) {
                    MultiException.push((Object)((Object)this), (Exception)ex, exceptionStack);
                }
            }
            MultiException.checkAndThrow((String)("Could not execute all actions of Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]!"), exceptionStack);
            this.logger.info("Deactivate Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "] because all actions are sucessfully executed.");
        }
        catch (CouldNotPerformException ex) {
            try {
                throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)ex, (Logger)this.logger);
            }
            catch (Throwable throwable) {
                try (ClosableDataBuilder dataBuilder = this.getDataBuilder((Object)this);){
                    ((SceneDataType.SceneData.Builder)dataBuilder.getInternalBuilder()).getActivationStateBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE);
                    throw throwable;
                }
            }
        }
        Throwable throwable = null;
        try (ClosableDataBuilder dataBuilder = this.getDataBuilder((Object)this);){
            ((SceneDataType.SceneData.Builder)dataBuilder.getInternalBuilder()).getActivationStateBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE);
            return;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Finished scene: " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
    }

    public Future<Void> applyAction(final ActionConfigType.ActionConfig actionConfig) throws CouldNotPerformException, InterruptedException {
        return GlobalCachedExecutorService.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    SceneControllerImpl.this.logger.info("applyAction: " + actionConfig.getLabel());
                    Object attribute = new ServiceJSonProcessor().deserialize(actionConfig.getServiceAttribute(), actionConfig.getServiceAttributeType());
                    ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(actionConfig.getServiceType()).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
                    Service.invokeServiceMethod((ServiceTemplateType.ServiceTemplate)serviceTemplate, (Service)SceneControllerImpl.this, (Object[])new Object[]{attribute});
                    return null;
                }
                catch (CouldNotPerformException ex) {
                    throw new CouldNotPerformException("Could not apply action!", (Throwable)ex);
                }
            }
        });
    }

    protected boolean isAutostartEnabled() throws CouldNotPerformException {
        return false;
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SceneDataType.SceneData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActivationStateType.ActivationState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionConfigType.ActionConfig.getDefaultInstance()));
    }
}

