/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.openbase.bco.dal.lib.layer.service.Service;
import org.openbase.bco.dal.lib.layer.service.ServiceJSonProcessor;
import org.openbase.bco.dal.lib.layer.unit.AbstractExecutableBaseUnitController;
import org.openbase.bco.dal.remote.control.action.Action;
import org.openbase.bco.dal.remote.unit.ButtonRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.GlobalCachedExecutorService;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.ButtonStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.dal.ButtonDataType;
import rst.domotic.unit.scene.SceneDataType;

public class SceneControllerImpl
extends AbstractExecutableBaseUnitController<SceneDataType.SceneData, SceneDataType.SceneData.Builder>
implements SceneController {
    private static final long ACTION_EXECUTION_TIMEOUT = 15000L;
    private final Object buttonObserverLock = new SyncObject("ButtonObserverLock");
    private final Set<ButtonRemote> buttonRemoteSet;
    private final List<Action> actionList;
    private final SyncObject actionListSync = new SyncObject("ActionListSync");
    private final Observer<ButtonDataType.ButtonData> buttonObserver;
    private boolean executing = false;
    public static final int ACTION_REPLAY = 3;
    public static final int ACTION_EXECUTION_DEPLAY = 2000;

    public SceneControllerImpl() throws InstantiationException {
        super(SceneControllerImpl.class, (GeneratedMessage.Builder)SceneDataType.SceneData.newBuilder());
        this.buttonRemoteSet = new HashSet<ButtonRemote>();
        this.actionList = new ArrayList<Action>();
        this.buttonObserver = (source, data) -> {
            if (data.getButtonState().getValue().equals((Object)ButtonStateType.ButtonState.State.PRESSED)) {
                this.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build());
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            Registries.getUnitRegistry().waitForData();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        SyncObject buttonRemote;
        config = super.applyConfigUpdate(config);
        try {
            Object object = this.buttonObserverLock;
            synchronized (object) {
                for (ButtonRemote buttonRemote2 : this.buttonRemoteSet) {
                    try {
                        this.logger.info("update: remove " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + " for button  " + buttonRemote2.getLabel());
                    }
                    catch (NotAvailableException ex) {
                        java.util.logging.Logger.getLogger(SceneControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    buttonRemote2.removeDataObserver(this.buttonObserver);
                }
                this.buttonRemoteSet.clear();
                for (UnitConfigType.UnitConfig unitConfig : Registries.getUnitRegistry().getUnitConfigsByLabelAndUnitType(config.getLabel(), UnitTemplateType.UnitTemplate.UnitType.BUTTON)) {
                    try {
                        buttonRemote = (ButtonRemote)Units.getUnit((UnitConfigType.UnitConfig)unitConfig, (boolean)false, (Class)Units.BUTTON);
                        this.buttonRemoteSet.add((ButtonRemote)buttonRemote);
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not register remote for Button[" + unitConfig.getLabel() + "]!", (Throwable)ex), (Logger)this.logger);
                    }
                }
                if (this.isActive()) {
                    for (ButtonRemote button : this.buttonRemoteSet) {
                        try {
                            this.logger.info("update: register " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + " for button  " + button.getLabel());
                        }
                        catch (NotAvailableException ex) {
                            java.util.logging.Logger.getLogger(SceneControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        button.addDataObserver(this.buttonObserver);
                    }
                }
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not init all related button remotes.", (Throwable)ex), (Logger)this.logger);
        }
        MultiException.ExceptionStack exceptionStack = null;
        buttonRemote = this.actionListSync;
        synchronized (buttonRemote) {
            this.actionList.clear();
            for (ActionConfigType.ActionConfig actionConfig : config.getSceneConfig().getActionConfigList()) {
                Action action = new Action();
                try {
                    action.init(actionConfig);
                    this.actionList.add(action);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)((Object)this), (Exception)((Object)ex), exceptionStack);
                }
            }
        }
        try {
            MultiException.checkAndThrow((String)("Could not fully init units of " + (Object)((Object)this)), exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws InterruptedException, CouldNotPerformException {
        super.activate();
        Object object = this.buttonObserverLock;
        synchronized (object) {
            this.buttonRemoteSet.stream().forEach(button -> button.addDataObserver(this.buttonObserver));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws InterruptedException, CouldNotPerformException {
        this.logger.debug("deactivate " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
        Object object = this.buttonObserverLock;
        synchronized (object) {
            this.buttonRemoteSet.stream().forEach(button -> button.removeDataObserver(this.buttonObserver));
        }
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activate Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        this.executing = true;
        HashMap<Future, Action> executionFutureList = new HashMap<Future, Action>();
        SyncObject syncObject = this.actionListSync;
        synchronized (syncObject) {
            for (Action action : this.actionList) {
                executionFutureList.put(action.execute(), action);
            }
        }
        Thread.sleep(11000L);
        syncObject = this.actionListSync;
        synchronized (syncObject) {
            for (Action action : this.actionList) {
                executionFutureList.put(action.execute(), action);
            }
        }
        MultiException.ExceptionStack exceptionStack = null;
        try {
            this.logger.debug("Waiting for action finalisation...");
            long checkStart = System.currentTimeMillis() + 15000L;
            for (Map.Entry futureActionEntry : executionFutureList.entrySet()) {
                if (((Future)futureActionEntry.getKey()).isDone()) continue;
                this.logger.info("Waiting for action [" + ((Action)futureActionEntry.getValue()).getConfig().getServiceAttributeType() + "]");
                try {
                    long timeout = checkStart - System.currentTimeMillis();
                    if (timeout <= 0L) {
                        throw new RejectedException("Rejected because of scene timeout.");
                    }
                    ((Future)futureActionEntry.getKey()).get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException | TimeoutException ex) {
                    MultiException.push((Object)((Object)this), (Exception)ex, exceptionStack);
                }
            }
            MultiException.checkAndThrow((String)"Could not execute all actions!", exceptionStack);
            this.logger.info("Deactivate Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "] because all actions are sucessfully executed.");
        }
        catch (CancellationException | CouldNotPerformException ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "] execution failed!"), (Logger)this.logger);
        }
        finally {
            for (Map.Entry futureActionEntry : executionFutureList.entrySet()) {
                if (((Future)futureActionEntry.getKey()).isDone()) continue;
                ((Future)futureActionEntry.getKey()).cancel(true);
            }
            this.executing = false;
            this.setActivationState(ActivationStateType.ActivationState.State.DEACTIVE);
        }
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Finished scene: " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public Future<Void> applyAction(final ActionConfigType.ActionConfig actionConfig) throws CouldNotPerformException, InterruptedException {
        return GlobalCachedExecutorService.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    SceneControllerImpl.this.logger.info("applyAction: " + actionConfig.getLabel());
                    Object attribute = new ServiceJSonProcessor().deserialize(actionConfig.getServiceAttribute(), actionConfig.getServiceAttributeType());
                    ServiceTemplateType.ServiceTemplate serviceTemplate = ServiceTemplateType.ServiceTemplate.newBuilder().setType(actionConfig.getServiceType()).setPattern(ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION).build();
                    Service.invokeServiceMethod((ServiceTemplateType.ServiceTemplate)serviceTemplate, (Service)SceneControllerImpl.this, (Object[])new Object[]{attribute});
                    return null;
                }
                catch (CouldNotPerformException ex) {
                    throw new CouldNotPerformException("Could not apply action!", (Throwable)ex);
                }
            }
        });
    }

    protected boolean isAutostartEnabled() throws CouldNotPerformException {
        return false;
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SceneDataType.SceneData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActivationStateType.ActivationState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionConfigType.ActionConfig.getDefaultInstance()));
    }
}

