/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import org.openbase.bco.manager.scene.core.SceneFactoryImpl;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.manager.scene.lib.SceneFactory;
import org.openbase.bco.manager.scene.lib.SceneManager;
import org.openbase.bco.registry.scene.lib.SceneRegistry;
import org.openbase.bco.registry.scene.lib.provider.SceneRegistryProvider;
import org.openbase.bco.registry.scene.remote.SceneRegistryRemote;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.ControllerRegistryImpl;
import org.openbase.jul.storage.registry.EnableableEntryRegistrySynchronizer;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;

public class SceneManagerController
implements SceneRegistryProvider,
SceneManager,
Launchable<Void>,
VoidInitializable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SceneManagerController.class);
    private static SceneManagerController instance;
    private final SceneFactory factory;
    private final ControllerRegistryImpl<String, SceneController> sceneRegistry;
    private final SceneRegistryRemote sceneRegistryRemote;
    private final EnableableEntryRegistrySynchronizer<String, SceneController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> sceneRegistrySynchronizer;

    public SceneManagerController() throws InstantiationException, InterruptedException {
        try {
            instance = this;
            this.factory = SceneFactoryImpl.getInstance();
            this.sceneRegistry = new ControllerRegistryImpl();
            this.sceneRegistryRemote = new SceneRegistryRemote();
            this.sceneRegistrySynchronizer = new EnableableEntryRegistrySynchronizer<String, SceneController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>(this.sceneRegistry, (RemoteRegistry)this.sceneRegistryRemote.getSceneConfigRemoteRegistry(), (Factory)this.factory){

                public boolean enablingCondition(UnitConfigType.UnitConfig config) {
                    return config.getEnablingState().getValue().equals((Object)EnablingStateType.EnablingState.State.ENABLED);
                }
            };
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public static SceneManagerController getInstance() throws NotAvailableException {
        if (instance == null) {
            throw new NotAvailableException(SceneManagerController.class);
        }
        return instance;
    }

    public void init() throws InitializationException, InterruptedException {
        try {
            this.sceneRegistryRemote.init();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        this.sceneRegistryRemote.activate();
        this.sceneRegistrySynchronizer.activate();
    }

    public boolean isActive() {
        return this.sceneRegistryRemote.isActive();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.sceneRegistrySynchronizer.deactivate();
        this.sceneRegistryRemote.deactivate();
    }

    public void shutdown() {
        this.sceneRegistrySynchronizer.shutdown();
        this.sceneRegistryRemote.shutdown();
        instance = null;
    }

    public SceneRegistry getSceneRegistry() throws NotAvailableException {
        return this.sceneRegistryRemote;
    }

    public RegistryImpl<String, SceneController> getSceneControllerRegistry() {
        return this.sceneRegistry;
    }
}

