/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import org.openbase.bco.manager.scene.core.SceneFactoryImpl;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.manager.scene.lib.SceneFactory;
import org.openbase.bco.manager.scene.lib.SceneManager;
import org.openbase.bco.registry.login.SystemLogin;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.pattern.Factory;
import org.openbase.jul.storage.registry.ControllerRegistryImpl;
import org.openbase.jul.storage.registry.EnableableEntryRegistrySynchronizer;
import org.openbase.jul.storage.registry.RegistryImpl;
import org.openbase.jul.storage.registry.RegistryRemote;
import org.openbase.jul.storage.registry.RemoteRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.domotic.state.EnablingStateType;
import rst.domotic.unit.UnitConfigType;

public class SceneManagerController
implements SceneManager,
Launchable<Void>,
VoidInitializable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SceneManagerController.class);
    private final SceneFactory factory;
    private final ControllerRegistryImpl<String, SceneController> sceneRegistry;
    private final EnableableEntryRegistrySynchronizer<String, SceneController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder> sceneRegistrySynchronizer;

    public SceneManagerController() throws InstantiationException, InterruptedException {
        try {
            this.factory = SceneFactoryImpl.getInstance();
            this.sceneRegistry = new ControllerRegistryImpl();
            this.sceneRegistrySynchronizer = new EnableableEntryRegistrySynchronizer<String, SceneController, UnitConfigType.UnitConfig, UnitConfigType.UnitConfig.Builder>(this.sceneRegistry, (RemoteRegistry)Registries.getSceneRegistry().getSceneConfigRemoteRegistry(), (RegistryRemote)Registries.getSceneRegistry(), (Factory)this.factory){

                public boolean enablingCondition(UnitConfigType.UnitConfig config) {
                    return config.getEnablingState().getValue().equals((Object)EnablingStateType.EnablingState.State.ENABLED);
                }
            };
        }
        catch (CouldNotPerformException ex) {
            throw new InstantiationException((Object)this, (Throwable)ex);
        }
    }

    public void init() throws InitializationException, InterruptedException {
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        Registries.waitForData();
        SystemLogin.loginBCOUser();
        this.sceneRegistrySynchronizer.activate();
    }

    public boolean isActive() {
        return this.sceneRegistrySynchronizer.isActive();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        this.sceneRegistrySynchronizer.deactivate();
    }

    public void shutdown() {
        this.sceneRegistrySynchronizer.shutdown();
    }

    public RegistryImpl<String, SceneController> getSceneControllerRegistry() {
        return this.sceneRegistry;
    }
}

