/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.manager.scene.core;

import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.Message;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import org.openbase.bco.dal.lib.layer.unit.AbstractExecutableBaseUnitController;
import org.openbase.bco.dal.remote.action.RemoteAction;
import org.openbase.bco.dal.remote.unit.ButtonRemote;
import org.openbase.bco.dal.remote.unit.Units;
import org.openbase.bco.manager.scene.lib.SceneController;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.exception.InstantiationException;
import org.openbase.jul.exception.MultiException;
import org.openbase.jul.exception.NotAvailableException;
import org.openbase.jul.exception.RejectedException;
import org.openbase.jul.exception.printer.ExceptionPrinter;
import org.openbase.jul.exception.printer.LogLevel;
import org.openbase.jul.extension.rst.processing.TimestampProcessor;
import org.openbase.jul.pattern.Observer;
import org.openbase.jul.schedule.SyncObject;
import org.slf4j.Logger;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;
import rst.domotic.action.ActionDescriptionType;
import rst.domotic.service.ServiceStateDescriptionType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.state.ActivationStateType;
import rst.domotic.state.ButtonStateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;
import rst.domotic.unit.dal.ButtonDataType;
import rst.domotic.unit.scene.SceneDataType;

public class SceneControllerImpl
extends AbstractExecutableBaseUnitController<SceneDataType.SceneData, SceneDataType.SceneData.Builder>
implements SceneController {
    public static final long ACTION_EXECUTION_TIMEOUT = 15000L;
    private final Object buttonObserverLock = new SyncObject("ButtonObserverLock");
    private final Set<ButtonRemote> buttonRemoteSet;
    private final List<RemoteAction> remoteActionList;
    private final SyncObject actionListSync = new SyncObject("ActionListSync");
    private final Observer<ButtonDataType.ButtonData> buttonObserver;

    public SceneControllerImpl() throws InstantiationException {
        super(SceneControllerImpl.class, (GeneratedMessage.Builder)SceneDataType.SceneData.newBuilder());
        this.buttonRemoteSet = new HashSet<ButtonRemote>();
        this.remoteActionList = new ArrayList<RemoteAction>();
        this.buttonObserver = (source, data) -> {
            if (data.getButtonStateLast().getValue().equals((Object)ButtonStateType.ButtonState.State.UNKNOWN)) {
                return;
            }
            if (data.getButtonState().getValue().equals((Object)ButtonStateType.ButtonState.State.PRESSED)) {
                this.setActivationState(ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.ACTIVE).build());
            }
        };
    }

    public void init(UnitConfigType.UnitConfig config) throws InitializationException, InterruptedException {
        try {
            Registries.getUnitRegistry().waitForData();
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)this, (Throwable)ex);
        }
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnitConfigType.UnitConfig applyConfigUpdate(UnitConfigType.UnitConfig config) throws CouldNotPerformException, InterruptedException {
        SyncObject buttonRemote;
        config = super.applyConfigUpdate(config);
        try {
            Object object = this.buttonObserverLock;
            synchronized (object) {
                for (ButtonRemote buttonRemote2 : this.buttonRemoteSet) {
                    try {
                        this.logger.info("update: remove " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + " for button  " + buttonRemote2.getLabel());
                    }
                    catch (NotAvailableException ex) {
                        java.util.logging.Logger.getLogger(SceneControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    buttonRemote2.removeDataObserver(this.buttonObserver);
                }
                this.buttonRemoteSet.clear();
                for (UnitConfigType.UnitConfig unitConfig : Registries.getUnitRegistry().getUnitConfigsByLabelAndUnitType(config.getLabel(), UnitTemplateType.UnitTemplate.UnitType.BUTTON)) {
                    try {
                        buttonRemote = (ButtonRemote)Units.getUnit((UnitConfigType.UnitConfig)unitConfig, (boolean)false, (Class)Units.BUTTON);
                        this.buttonRemoteSet.add((ButtonRemote)buttonRemote);
                    }
                    catch (CouldNotPerformException ex) {
                        ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not register remote for Button[" + unitConfig.getLabel() + "]!", (Throwable)ex), (Logger)this.logger);
                    }
                }
                if (this.isActive()) {
                    for (ButtonRemote button : this.buttonRemoteSet) {
                        try {
                            this.logger.info("update: register " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + " for button  " + button.getLabel());
                        }
                        catch (NotAvailableException ex) {
                            java.util.logging.Logger.getLogger(SceneControllerImpl.class.getName()).log(Level.SEVERE, null, ex);
                        }
                        button.addDataObserver(this.buttonObserver);
                    }
                }
            }
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)new CouldNotPerformException("Could not init all related button remotes.", (Throwable)ex), (Logger)this.logger);
        }
        MultiException.ExceptionStack exceptionStack = null;
        buttonRemote = this.actionListSync;
        synchronized (buttonRemote) {
            this.remoteActionList.clear();
            for (ServiceStateDescriptionType.ServiceStateDescription serviceStateDescription : config.getSceneConfig().getRequiredServiceStateDescriptionList()) {
                RemoteAction remoteAction = new RemoteAction();
                try {
                    remoteAction.init(ActionDescriptionType.ActionDescription.newBuilder().setServiceStateDescription(serviceStateDescription).build());
                    this.remoteActionList.add(remoteAction);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)((Object)this), (Exception)((Object)ex), exceptionStack);
                }
            }
            for (ServiceStateDescriptionType.ServiceStateDescription serviceStateDescription : config.getSceneConfig().getOptionalServiceStateDescriptionList()) {
                RemoteAction remoteAction = new RemoteAction();
                try {
                    remoteAction.init(ActionDescriptionType.ActionDescription.newBuilder().setServiceStateDescription(serviceStateDescription).build());
                    this.remoteActionList.add(remoteAction);
                }
                catch (CouldNotPerformException ex) {
                    exceptionStack = MultiException.push((Object)((Object)this), (Exception)((Object)ex), (MultiException.ExceptionStack)exceptionStack);
                }
            }
        }
        try {
            MultiException.checkAndThrow((String)("Could not fully init units of " + (Object)((Object)this)), (MultiException.ExceptionStack)exceptionStack);
        }
        catch (CouldNotPerformException ex) {
            ExceptionPrinter.printHistory((Throwable)ex, (Logger)this.logger, (LogLevel)LogLevel.WARN);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws InterruptedException, CouldNotPerformException {
        super.activate();
        Object object = this.buttonObserverLock;
        synchronized (object) {
            this.buttonRemoteSet.stream().forEach(button -> button.addDataObserver(this.buttonObserver));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() throws InterruptedException, CouldNotPerformException {
        this.logger.debug("deactivate " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
        Object object = this.buttonObserverLock;
        synchronized (object) {
            this.buttonRemoteSet.stream().forEach(button -> button.removeDataObserver(this.buttonObserver));
        }
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws CouldNotPerformException, InterruptedException {
        this.logger.info("Activate Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "]");
        HashMap<Future, RemoteAction> executionFutureList = new HashMap<Future, RemoteAction>();
        SyncObject syncObject = this.actionListSync;
        synchronized (syncObject) {
            for (RemoteAction action : this.remoteActionList) {
                executionFutureList.put(action.execute(), action);
            }
        }
        MultiException.ExceptionStack exceptionStack = null;
        try {
            this.logger.info("Waiting for action finalisation...");
            long checkStart = System.currentTimeMillis() + 15000L;
            for (Map.Entry futureActionEntry : executionFutureList.entrySet()) {
                if (((Future)futureActionEntry.getKey()).isDone()) continue;
                this.logger.info("Waiting for action [" + ((RemoteAction)futureActionEntry.getValue()).getActionDescription().getServiceStateDescription().getServiceAttributeType() + "]");
                try {
                    long timeout = checkStart - System.currentTimeMillis();
                    if (timeout <= 0L) {
                        throw new RejectedException("Rejected because of scene timeout.");
                    }
                    ((Future)futureActionEntry.getKey()).get(timeout, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException | TimeoutException ex) {
                    MultiException.push((Object)((Object)this), (Exception)ex, exceptionStack);
                }
            }
            MultiException.checkAndThrow((String)"Could not execute all actions!", exceptionStack);
            this.logger.info("Deactivate Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "] because all actions are successfully executed.");
        }
        catch (CancellationException | CouldNotPerformException ex) {
            throw (CouldNotPerformException)ExceptionPrinter.printHistoryAndReturnThrowable((Throwable)new CouldNotPerformException("Scene[" + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel() + "] execution failed!", ex), (Logger)this.logger);
        }
        finally {
            for (Map.Entry futureActionEntry : executionFutureList.entrySet()) {
                if (((Future)futureActionEntry.getKey()).isDone()) continue;
                ((Future)futureActionEntry.getKey()).cancel(true);
            }
            this.applyDataUpdate(ActivationStateType.ActivationState.newBuilder().setValue(ActivationStateType.ActivationState.State.DEACTIVE).setTimestamp(TimestampProcessor.getCurrentTimestamp()).build(), ServiceTemplateType.ServiceTemplate.ServiceType.ACTIVATION_STATE_SERVICE);
        }
    }

    protected void stop() throws CouldNotPerformException, InterruptedException {
        this.logger.debug("Finished scene: " + ((UnitConfigType.UnitConfig)this.getConfig()).getLabel());
    }

    protected boolean isAutostartEnabled() throws CouldNotPerformException {
        return false;
    }

    static {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)SceneDataType.SceneData.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActivationStateType.ActivationState.getDefaultInstance()));
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter((Message)ActionDescriptionType.ActionDescription.getDefaultInstance()));
    }
}

