/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.psc.lib.jp;

import java.util.List;
import org.openbase.jps.exception.JPBadArgumentException;
import org.openbase.jps.exception.JPNotAvailableException;
import org.openbase.jps.preset.AbstractJPFloat;

public class JPThreshold
extends AbstractJPFloat {
    public static final String[] COMMAND_IDENTIFIERS = new String[]{"-t", "--threshold"};

    public JPThreshold() {
        super(COMMAND_IDENTIFIERS);
    }

    protected Float getPropertyDefaultValue() throws JPNotAvailableException {
        return Float.valueOf(0.0f);
    }

    public String getDescription() {
        return "Probability threshold defining how big the probability has to be, to trigger its corresponding action.";
    }

    protected Float parse(List<String> arguments) throws JPBadArgumentException {
        Float f = super.parse(arguments);
        if (f.floatValue() > 1.0f || f.floatValue() < 0.0f) {
            throw new JPBadArgumentException("Threshold has to be between 0.0 and 1.0!");
        }
        return f;
    }
}

