/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.psc.lib.pointing;

import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.geometry.Point3D;
import org.openbase.bco.psc.lib.pointing.JointPair;
import org.openbase.bco.psc.lib.pointing.Joints;
import rst.geometry.Ray3DFloatType;
import rst.geometry.TranslationType;
import rst.kinematics.Posture3DFloatType;
import rst.math.Vec3DFloatType;
import rst.tracking.PointingRay3DFloatType;
import rst.tracking.TrackedPosture3DFloatType;

public class PostureFunctions {
    public static final Point3D UP = new Point3D(0.0, 0.0, 1.0);

    public static final JointPair getJointPair(boolean right, PointingRay3DFloatType.PointingRay3DFloat.PointingType type) {
        if (right) {
            switch (type) {
                case HEAD_HAND: {
                    return new JointPair(Joints.Head, Joints.HandRight);
                }
                case HEAD_FINGERTIP: {
                    return new JointPair(Joints.Head, Joints.HandTipRight);
                }
                case SHOULDER_HAND: {
                    return new JointPair(Joints.ShoulderRight, Joints.HandRight);
                }
                case FOREARM: {
                    return new JointPair(Joints.ElbowRight, Joints.HandRight);
                }
                case HAND: {
                    return new JointPair(Joints.HandRight, Joints.HandTipRight);
                }
            }
            return new JointPair(Joints.Head, Joints.HandRight);
        }
        switch (type) {
            case HEAD_HAND: {
                return new JointPair(Joints.Head, Joints.HandLeft);
            }
            case HEAD_FINGERTIP: {
                return new JointPair(Joints.Head, Joints.HandTipLeft);
            }
            case SHOULDER_HAND: {
                return new JointPair(Joints.ShoulderLeft, Joints.HandLeft);
            }
            case FOREARM: {
                return new JointPair(Joints.ElbowLeft, Joints.HandLeft);
            }
            case HAND: {
                return new JointPair(Joints.HandLeft, Joints.HandTipLeft);
            }
        }
        return new JointPair(Joints.Head, Joints.HandLeft);
    }

    public static Joints otherJoint(Joints joint) {
        switch (joint) {
            case AnkleLeft: {
                return Joints.AnkleRight;
            }
            case AnkleRight: {
                return Joints.AnkleLeft;
            }
            case ElbowLeft: {
                return Joints.ElbowRight;
            }
            case ElbowRight: {
                return Joints.ElbowLeft;
            }
            case FootLeft: {
                return Joints.FootRight;
            }
            case FootRight: {
                return Joints.FootLeft;
            }
            case HandLeft: {
                return Joints.HandRight;
            }
            case HandRight: {
                return Joints.HandLeft;
            }
            case HandTipLeft: {
                return Joints.HandTipRight;
            }
            case HandTipRight: {
                return Joints.HandTipLeft;
            }
            case HipLeft: {
                return Joints.HipRight;
            }
            case HipRight: {
                return Joints.HipLeft;
            }
            case KneeLeft: {
                return Joints.KneeRight;
            }
            case KneeRight: {
                return Joints.KneeLeft;
            }
            case ShoulderLeft: {
                return Joints.ShoulderRight;
            }
            case ShoulderRight: {
                return Joints.ShoulderLeft;
            }
            case ThumbLeft: {
                return Joints.ThumbRight;
            }
            case ThumbRight: {
                return Joints.ThumbLeft;
            }
            case WristLeft: {
                return Joints.WristRight;
            }
            case WristRight: {
                return Joints.WristLeft;
            }
        }
        return joint;
    }

    public static final Vec3DFloatType.Vec3DFloat toVec3DFloat(TranslationType.Translation translation) {
        return Vec3DFloatType.Vec3DFloat.newBuilder().setX((float)translation.getX()).setY((float)translation.getY()).setZ((float)translation.getZ()).build();
    }

    public static final Vec3DFloatType.Vec3DFloat toVec3DFloat(Point3D point) {
        return Vec3DFloatType.Vec3DFloat.newBuilder().setX((float)point.getX()).setY((float)point.getY()).setZ((float)point.getZ()).build();
    }

    public static final Vec3DFloatType.Vec3DFloat getVec(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, Joints joint) {
        return PostureFunctions.toVec3DFloat(posture.getPosture().getPosition(joint.getValue()));
    }

    public static final Vec3DFloatType.Vec3DFloat subtract(Vec3DFloatType.Vec3DFloat first, Vec3DFloatType.Vec3DFloat second) {
        return Vec3DFloatType.Vec3DFloat.newBuilder().setX(first.getX() - second.getX()).setY(first.getY() - second.getY()).setZ(first.getZ() - second.getZ()).build();
    }

    public static Ray3DFloatType.Ray3DFloat getRay(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, JointPair jointPair) {
        Vec3DFloatType.Vec3DFloat startVec = PostureFunctions.getVec(posture, jointPair.getJoint1());
        Vec3DFloatType.Vec3DFloat endVec = PostureFunctions.getVec(posture, jointPair.getJoint2());
        Vec3DFloatType.Vec3DFloat direction = PostureFunctions.subtract(endVec, startVec);
        return Ray3DFloatType.Ray3DFloat.newBuilder().setOrigin(endVec).setDirection(direction).build();
    }

    public static final PointingRay3DFloatType.PointingRay3DFloat getPointingRay(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right, double pointingProbability, PointingRay3DFloatType.PointingRay3DFloat.PointingType type) {
        JointPair jointPair = PostureFunctions.getJointPair(right, type);
        return PointingRay3DFloatType.PointingRay3DFloat.newBuilder().setRay(PostureFunctions.getRay(posture, jointPair)).setCertainty((float)pointingProbability).setType(type).setRightHandPointing(right).build();
    }

    public static final PointingRay3DFloatType.PointingRay3DFloat getPointingRayWithConfidence(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right, double pointingProbability, PointingRay3DFloatType.PointingRay3DFloat.PointingType type) {
        JointPair jointPair = PostureFunctions.getJointPair(right, type);
        float certainty = posture.getConfidence(jointPair.getJoint1().getValue()) * posture.getConfidence(jointPair.getJoint2().getValue());
        return PostureFunctions.getPointingRay(posture, right, (double)certainty * pointingProbability, type);
    }

    public static final Collection<PointingRay3DFloatType.PointingRay3DFloat> getAllRaysForSideAndTypesWithConfidence(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right, double pointingProbability, Collection<PointingRay3DFloatType.PointingRay3DFloat.PointingType> types) {
        return types.stream().map(type -> PostureFunctions.getPointingRayWithConfidence(posture, right, pointingProbability / (double)types.size(), type)).collect(Collectors.toList());
    }

    public static final Collection<PointingRay3DFloatType.PointingRay3DFloat> getAllRaysForSideWithConfidence(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right, double pointingProbability) {
        return PostureFunctions.getAllRaysForSideAndTypesWithConfidence(posture, right, pointingProbability, Arrays.asList(PointingRay3DFloatType.PointingRay3DFloat.PointingType.values()));
    }

    public static final boolean checkPosture(TrackedPosture3DFloatType.TrackedPosture3DFloat posture) {
        if (!posture.hasPosture()) {
            return false;
        }
        Posture3DFloatType.Posture3DFloat post = posture.getPosture();
        return post.getPositionCount() != 0 && post.getPositionCount() == posture.getConfidenceCount();
    }

    public static final double postureConfidence(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right) {
        double confidence = posture.getConfidence(Joints.Head.getValue());
        if (right) {
            confidence *= (double)posture.getConfidence(Joints.ShoulderRight.getValue());
            confidence *= (double)posture.getConfidence(Joints.ElbowRight.getValue());
            confidence *= (double)posture.getConfidence(Joints.WristRight.getValue());
            confidence *= (double)posture.getConfidence(Joints.HandRight.getValue());
        } else {
            confidence *= (double)posture.getConfidence(Joints.ShoulderLeft.getValue());
            confidence *= (double)posture.getConfidence(Joints.ElbowLeft.getValue());
            confidence *= (double)posture.getConfidence(Joints.WristLeft.getValue());
            confidence *= (double)posture.getConfidence(Joints.HandLeft.getValue());
        }
        return confidence;
    }

    public static final boolean checkConfidences(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right) {
        return PostureFunctions.postureConfidence(posture, right) == 1.0;
    }

    public static final TranslationType.Translation toTranslation(Point3D point) {
        return TranslationType.Translation.newBuilder().setX(point.getX()).setY(point.getY()).setZ(point.getZ()).build();
    }

    public static final Point3D toPoint3D(TranslationType.Translation translation) {
        return new Point3D(translation.getX(), translation.getY(), translation.getZ());
    }

    public static final Point3D getPoint3D(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, Joints joint) {
        return PostureFunctions.toPoint3D(posture.getPosture().getPosition(joint.getValue()));
    }

    public static final Point3D getDirection(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, JointPair jointPair) {
        Point3D start = PostureFunctions.getPoint3D(posture, jointPair.getJoint1());
        Point3D end = PostureFunctions.getPoint3D(posture, jointPair.getJoint2());
        return end.subtract(start);
    }

    public static final Point3D projectOn(Point3D vector, Point3D onto) {
        return onto.multiply(onto.dotProduct(vector) / Math.pow(onto.magnitude(), 2.0));
    }

    public static final Point3D projectOrthogonal(Point3D vector, Point3D orthogonal) {
        return vector.subtract(PostureFunctions.projectOn(vector, orthogonal));
    }

    public static final double getSignedAngle(Point3D vector1, Point3D vector2, Point3D up) {
        double angle = vector1.angle(vector2);
        return up.dotProduct(vector2.crossProduct(vector1)) < 0.0 ? -angle : angle;
    }

    public static final Point3D postureUpDirection(TrackedPosture3DFloatType.TrackedPosture3DFloat posture) {
        return PostureFunctions.getDirection(posture, new JointPair(Joints.SpineBase, Joints.Neck)).normalize();
    }

    public static final Point3D postureUpDirection(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean relative) {
        return relative ? PostureFunctions.postureUpDirection(posture) : UP;
    }

    public static final Point3D postureRightDirection(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, Point3D up) {
        Point3D hipDir = PostureFunctions.getDirection(posture, new JointPair(Joints.HipLeft, Joints.HipRight));
        Point3D shoulderDir = PostureFunctions.getDirection(posture, new JointPair(Joints.ShoulderLeft, Joints.ShoulderRight));
        return PostureFunctions.projectOrthogonal(hipDir.add(shoulderDir.multiply(0.5)), up).normalize();
    }

    public static final Point3D postureRightDirection(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean relative) {
        return PostureFunctions.postureRightDirection(posture, PostureFunctions.postureUpDirection(posture, relative));
    }

    public static final Point3D postureFrontDirection(Point3D up, Point3D right) {
        return up.crossProduct(right);
    }

    public static final Point3D postureFrontDirection(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, Point3D up) {
        return PostureFunctions.postureFrontDirection(up, PostureFunctions.postureRightDirection(posture, up));
    }

    public static final Point3D postureFrontDirection(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean relative) {
        return PostureFunctions.postureFrontDirection(posture, PostureFunctions.postureUpDirection(posture, relative));
    }

    public static final double getElbowAngle(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right) {
        JointPair pair1 = right ? new JointPair(Joints.ElbowRight, Joints.ShoulderRight) : new JointPair(Joints.ElbowLeft, Joints.ShoulderLeft);
        JointPair pair2 = right ? new JointPair(Joints.ElbowRight, Joints.HandRight) : new JointPair(Joints.ElbowLeft, Joints.HandLeft);
        return PostureFunctions.getDirection(posture, pair1).angle(PostureFunctions.getDirection(posture, pair2));
    }

    public static final double getHandHeightAngle(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right, boolean relative) {
        JointPair armJoints = right ? new JointPair(Joints.ShoulderRight, Joints.HandRight) : new JointPair(Joints.ShoulderLeft, Joints.HandLeft);
        Point3D direction = PostureFunctions.getDirection(posture, armJoints);
        Point3D up = PostureFunctions.postureUpDirection(posture, relative);
        return up.angle(direction);
    }

    public static final double getElbowHeightAngle(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right, boolean relative) {
        JointPair armJoints = right ? new JointPair(Joints.ShoulderRight, Joints.ElbowRight) : new JointPair(Joints.ShoulderLeft, Joints.ElbowLeft);
        Point3D direction = PostureFunctions.getDirection(posture, armJoints);
        Point3D up = PostureFunctions.postureUpDirection(posture, relative);
        return up.angle(direction);
    }

    public static final double getSignedHorizontalAngle(TrackedPosture3DFloatType.TrackedPosture3DFloat posture, boolean right, boolean relative) {
        Joints handJoint = right ? Joints.HandRight : Joints.HandLeft;
        Point3D up = PostureFunctions.postureUpDirection(posture, relative);
        Point3D front = PostureFunctions.postureFrontDirection(posture, up);
        Point3D direction = PostureFunctions.projectOrthogonal(PostureFunctions.getDirection(posture, new JointPair(Joints.SpineMid, handJoint)), up);
        return PostureFunctions.getSignedAngle(front, direction, up);
    }
}

