/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.psc.lib.rsb;

import com.google.protobuf.GeneratedMessage;
import org.openbase.bco.psc.lib.rsb.LocalConfigProviderInterface;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.extension.rsb.iface.RSBListener;
import org.openbase.jul.iface.Activatable;
import org.openbase.jul.iface.Launchable;
import org.openbase.jul.iface.VoidInitializable;
import org.openbase.jul.schedule.WatchDog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.AbstractEventHandler;
import rsb.Handler;
import rsb.converter.Converter;
import rsb.converter.DefaultConverterRepository;
import rsb.converter.ProtocolBufferConverter;

public abstract class AbstractRSBListenerConnection
implements Launchable<Void>,
VoidInitializable,
LocalConfigProviderInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRSBListenerConnection.class);
    private final AbstractEventHandler handler;
    private RSBListener listener;
    protected WatchDog listenerWatchDog;
    protected boolean initialized = false;

    public AbstractRSBListenerConnection(AbstractEventHandler handler) {
        this.handler = handler;
    }

    protected abstract RSBListener getInitializedListener() throws InitializationException;

    protected abstract void registerConverters();

    protected <M extends GeneratedMessage> void registerConverterForType(M defaultInstance) {
        DefaultConverterRepository.getDefaultConverterRepository().addConverter((Converter)new ProtocolBufferConverter(defaultInstance));
    }

    protected void initListener() throws InitializationException, InterruptedException {
        try {
            this.listener = this.getInitializedListener();
            this.listener.addHandler((Handler)this.handler, true);
            this.listenerWatchDog = new WatchDog((Activatable)this.listener, "listener");
        }
        catch (CouldNotPerformException ex) {
            throw new InitializationException((Object)"RSB Listener", (Throwable)ex);
        }
    }

    public void init() throws InitializationException, InterruptedException {
        if (!this.initialized) {
            try {
                LOGGER.info("Initializing RSB connection.");
                this.registerConverters();
                this.initListener();
            }
            catch (InitializationException ex) {
                throw new InitializationException(AbstractRSBListenerConnection.class, (Throwable)ex);
            }
            this.initialized = true;
        }
    }

    public void activate() throws CouldNotPerformException, InterruptedException {
        if (!this.initialized) {
            throw new CouldNotPerformException("Do not call activate before init!");
        }
        LOGGER.info("Activating RSB connection.");
        this.listenerWatchDog.activate();
    }

    public void deactivate() throws CouldNotPerformException, InterruptedException {
        LOGGER.info("Deactivating RSB connection.");
        this.listenerWatchDog.deactivate();
    }

    public boolean isActive() {
        return this.listenerWatchDog.isActive();
    }
}

