/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.psc.lib.registry;

import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openbase.bco.registry.lib.util.UnitConfigProcessor;
import org.openbase.bco.registry.remote.Registries;
import org.openbase.jul.exception.CouldNotPerformException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rst.configuration.MetaConfigType;
import rst.domotic.service.ServiceConfigType;
import rst.domotic.service.ServiceTemplateType;
import rst.domotic.unit.UnitConfigType;
import rst.domotic.unit.UnitTemplateType;

public class PointingUnitChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(PointingUnitChecker.class);

    public static boolean isPointingControlUnit(UnitConfigType.UnitConfig config, List<String> registryFlags) throws InterruptedException, CouldNotPerformException {
        if (config != null && PointingUnitChecker.isRegistryFlagSet(config.getMetaConfig(), registryFlags)) {
            return PointingUnitChecker.hasPowerStateService(config) && PointingUnitChecker.isDalOrGroupWithLocation(config);
        }
        return false;
    }

    public static boolean isDalOrGroupWithLocation(UnitConfigType.UnitConfig config) throws InterruptedException, CouldNotPerformException {
        try {
            if (config != null && (config.getType() == UnitTemplateType.UnitTemplate.UnitType.UNIT_GROUP || UnitConfigProcessor.isDalUnit((UnitConfigType.UnitConfig)config))) {
                return PointingUnitChecker.hasLocationDataAndBoundingBox(config);
            }
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("Could not check if unit " + config.getLabel() + " is dal unit.", (Throwable)ex);
        }
        return false;
    }

    public static boolean hasLocationDataAndBoundingBox(UnitConfigType.UnitConfig config) throws InterruptedException, CouldNotPerformException {
        if (!PointingUnitChecker.hasLocationData(config)) {
            return false;
        }
        try {
            Registries.getLocationRegistry((boolean)true).getUnitBoundingBoxCenterGlobalPoint3d(config);
            return true;
        }
        catch (CouldNotPerformException ex) {
            return false;
        }
    }

    public static boolean hasLocationData(UnitConfigType.UnitConfig config) throws InterruptedException, CouldNotPerformException {
        try {
            Registries.getLocationRegistry((boolean)true).getUnitToRootTransformationFuture(config).get(10000L, TimeUnit.SECONDS);
        }
        catch (TimeoutException | CouldNotPerformException ex) {
            throw new CouldNotPerformException("GlobalTransformReceiver not available.", ex);
        }
        catch (ExecutionException ex) {
            return false;
        }
        return true;
    }

    private static boolean hasPowerStateService(UnitConfigType.UnitConfig config) throws InterruptedException {
        for (ServiceConfigType.ServiceConfig sc : config.getServiceConfigList()) {
            ServiceTemplateType.ServiceTemplate.ServiceType type;
            try {
                type = Registries.getUnitRegistry().getServiceTemplateById(sc.getServiceDescription().getServiceTemplateId()).getType();
            }
            catch (CouldNotPerformException ex) {
                type = sc.getServiceDescription().getType();
            }
            if (ServiceTemplateType.ServiceTemplate.ServiceType.POWER_STATE_SERVICE != type || ServiceTemplateType.ServiceTemplate.ServicePattern.OPERATION != sc.getServiceDescription().getPattern()) continue;
            return true;
        }
        return false;
    }

    private static boolean isRegistryFlagSet(MetaConfigType.MetaConfig meta, List<String> registryFlags) {
        if (meta == null || meta.getEntryList() == null) {
            return false;
        }
        return meta.getEntryList().stream().anyMatch(entry -> registryFlags.contains(entry.getKey()));
    }
}

