/*
 * Decompiled with CFR 0.152.
 */
package org.openbase.bco.psc.lib.rsb;

import com.google.protobuf.GeneratedMessage;
import org.openbase.bco.psc.lib.rsb.AbstractRSBListenerConnection;
import org.openbase.jul.exception.CouldNotPerformException;
import org.openbase.jul.exception.InitializationException;
import org.openbase.jul.extension.rsb.iface.RSBInformer;
import org.openbase.jul.schedule.WatchDog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rsb.AbstractEventHandler;
import rsb.Event;

public abstract class AbstractRSBDualConnection<T extends GeneratedMessage>
extends AbstractRSBListenerConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractRSBDualConnection.class);
    private RSBInformer<T> informer;
    private WatchDog informerWatchDog;

    public AbstractRSBDualConnection(AbstractEventHandler handler) {
        super(handler);
    }

    protected abstract RSBInformer<T> getInitializedInformer() throws InitializationException;

    public void publishData(T data) throws CouldNotPerformException, InterruptedException {
        LOGGER.trace("Publishing data via RSB.");
        try {
            this.informer.publish(data);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("RSB informer could not send the data.", (Throwable)ex);
        }
    }

    public void publishEvent(Event event) throws CouldNotPerformException, InterruptedException {
        LOGGER.trace("Publishing an event via RSB.");
        try {
            this.informer.publish(event);
        }
        catch (CouldNotPerformException ex) {
            throw new CouldNotPerformException("RSB informer could not send the event.", (Throwable)ex);
        }
    }

    @Override
    protected abstract void registerConverters();

    @Override
    public void init() throws InitializationException, InterruptedException {
        if (!this.initialized) {
            try {
                LOGGER.info("Initializing RSB connection.");
                this.registerConverters();
                this.informer = this.getInitializedInformer();
                this.informerWatchDog = new WatchDog(this.informer, "informer");
                this.initListener();
            }
            catch (CouldNotPerformException ex) {
                throw new InitializationException(AbstractRSBListenerConnection.class, (Throwable)ex);
            }
            this.initialized = true;
        }
    }

    @Override
    public void activate() throws CouldNotPerformException, InterruptedException {
        if (!this.initialized) {
            throw new CouldNotPerformException("Do not call activate before init!");
        }
        LOGGER.info("Activating RSB connection.");
        this.informerWatchDog.activate();
        this.listenerWatchDog.activate();
    }

    @Override
    public void deactivate() throws CouldNotPerformException, InterruptedException {
        super.deactivate();
        this.informerWatchDog.deactivate();
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.informerWatchDog.isActive();
    }
}

